/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.automerge;

import com.tssap.dtr.client.eclipse.automerge.AutomergeException;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AutomergeEngine {
    private List fAllCollision = new ArrayList();

    public void addCollision(Collision collision) {
        collision.executeDifferencer();
        this.fAllCollision.add(collision);
    }

    public void removeCollision(Collision collision) {
        this.fAllCollision.remove(collision);
    }

    public void updateCollision(Collision collision) {
        if (!collision.isResolved()) {
            collision.executeDifferencer();
        }
    }

    public void updateAllCollisions() {
        Iterator iter = this.fAllCollision.iterator();
        while (iter.hasNext()) {
            Collision col = (Collision)iter.next();
            if (col.isResolved()) continue;
            col.executeDifferencer();
        }
    }

    public Collision[] getCollisions() {
        return this.fAllCollision.toArray(new Collision[this.fAllCollision.size()]);
    }

    public void runAutomerge(Collision collision, boolean resolve, boolean forceIntersecting) throws AutomergeException {
        collision.runAutomerge(false, resolve, forceIntersecting);
    }

    public void runAutomerge(boolean resolve, boolean forceIntersecting) throws AutomergeException {
        Iterator i = this.fAllCollision.iterator();
        while (i.hasNext()) {
            Collision collision = (Collision)i.next();
            collision.runAutomerge(false, resolve, forceIntersecting);
        }
    }

    public void runAutomergePreview(Collision collision, boolean resolve, boolean forceIntersecting) throws AutomergeException {
        collision.runAutomerge(true, resolve, forceIntersecting);
    }

    public void runAutomergePreview(boolean resolve, boolean forceIntersecting) throws AutomergeException {
        Iterator i = this.fAllCollision.iterator();
        while (i.hasNext()) {
            Collision collision = (Collision)i.next();
            collision.runAutomerge(true, resolve, forceIntersecting);
        }
    }

    public String getPreviewResult(Collision collision, boolean forceIntersecting) throws AutomergeException {
        return collision.getPreviewResult(forceIntersecting);
    }

    public void finish() {
        Collision[] collisions = this.getCollisions();
        int i = 0;
        while (i < collisions.length) {
            collisions[i].finish();
            ++i;
        }
    }
}

