/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.eclipse.workspaceMonitor.DAVFileValidatior;
import com.tssap.dtr.client.eclipse.workspaceMonitor.DAVMoveDeleteHook;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.core.simpleAccess.SimpleAccessOperations;

public class DAVTeamProvider
extends RepositoryProvider {
    public static final QualifiedName PROJECT_CONFIGURATION_PROPERTIES = new QualifiedName("com.tssap.dtr.client.eclipse", "config.properties");
    public static final QualifiedName DTR_CLIENTDEF_NAME = new QualifiedName("com.tssap.dtr.client.eclipse", "dtr.clientdef.name");
    private IVersionedFileSystemManager m_vfsManager = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$DAVTeamProvider == null ? (class$com$tssap$dtr$client$eclipse$DAVTeamProvider = DAVTeamProvider.class$("com.tssap.dtr.client.eclipse.DAVTeamProvider")) : class$com$tssap$dtr$client$eclipse$DAVTeamProvider));
    private IMoveDeleteHook fMoveDeleteHook;
    private IFileModificationValidator fValidator;
    public static Set _moveDeleteHookListeners = new HashSet();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$DAVTeamProvider;

    public void configureProject() throws CoreException {
        String clientDefName = (String)this.getProject().getSessionProperty(PROJECT_CONFIGURATION_PROPERTIES);
        if (clientDefName != null) {
            this.getProject().setPersistentProperty(DTR_CLIENTDEF_NAME, clientDefName);
        } else {
            Logbook.getErrorChapter().println("Unable to associate project " + this.getProject().getName() + " with DAVTeamProvider - no clientDefName was specified.");
        }
        this.getProject().setSessionProperty(DTR_CLIENTDEF_NAME, null);
    }

    public void deconfigure() {
        try {
            this.getProject().setPersistentProperty(DTR_CLIENTDEF_NAME, null);
        }
        catch (CoreException deconfigurationProblem) {
            Logbook.getErrorChapter().println("Unable to deconfigure project: " + deconfigurationProblem.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)deconfigurationProblem);
        }
    }

    public String getID() {
        return "com.tssap.dtr.client.eclipse.DAVTeamProvider";
    }

    public SimpleAccessOperations getSimpleAccess() {
        return null;
    }

    public String getClientDefName() {
        try {
            return this.getProject().getPersistentProperty(DTR_CLIENTDEF_NAME);
        }
        catch (CoreException unableToReadProperty) {
            Logbook.getErrorChapter().println("Unable to associate IVersionedFileSystemManager with the project: " + unableToReadProperty.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)unableToReadProperty);
            return null;
        }
    }

    public IVersionedFileSystemManager getVFSManager() {
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable() && !VfsManagerProvider.getInstance().isUserLoggedinInSapIDE()) {
            return null;
        }
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            String clientDefName = this.getClientDefName();
            if (clientDefName == null) {
                return null;
            }
            IClient client = Configuration.getConfiguration().getClient(clientDefName);
            if (client == null) {
                return null;
            }
            IVfsContext context = client.getContext();
            if (context != null) {
                try {
                    this.m_vfsManager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(context);
                }
                catch (VfsException contextProblem) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)contextProblem);
                }
            } else {
                Logbook.getErrorChapter().println("Unable to get IVfsContext for the DTR client \"" + clientDefName + "\".");
            }
        }
        return this.m_vfsManager;
    }

    public IVfsFolderItem getFolderItem(IResource resource) {
        if (this.getVFSManager() == null) {
            return null;
        }
        try {
            return this.getVFSManager().getFolderItem(resource.getLocation().toOSString());
        }
        catch (VfsException unableToGet) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)unableToGet);
            return null;
        }
    }

    public IFileModificationValidator getFileModificationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new DAVFileValidatior(this);
        }
        return this.fValidator;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        if (this.fMoveDeleteHook == null) {
            this.fMoveDeleteHook = new DAVMoveDeleteHook(this);
        }
        return this.fMoveDeleteHook;
    }

    public static void addMoveDeleteHook(IMoveDeleteHook hook) {
        _moveDeleteHookListeners.add(hook);
    }

    public static void removeMoveDeleteHook(IMoveDeleteHook hook) {
        _moveDeleteHookListeners.remove(hook);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

