/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ConfigurationManager;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.ViewConfigurationRegistry;
import com.tssap.dtr.client.eclipse.ui.util.PluginImageRegistry;
import com.tssap.dtr.client.eclipse.ui.view.VfsElementAdapterFactory;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.actions.IVfsActionListener;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BluebirdPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.tssap.dtr.client.eclipse";
    public static final String PROVIDER_ID = "com.tssap.dtr.client.eclipse.DAVTeamProvider";
    private static BluebirdPlugin plugin;
    private static ViewConfigurationRegistry myViewConfigurationRegistry;
    private static final String CONFIGURATION_EXTENSION_POINT = "com.tssap.dtr.client.eclipse.configuration";
    private static final String IMAGES_DIRECTORY_ELEMENT = "images";
    private static final String PATH_ATTTRIBUTE = "path";
    private String myImagesDirectory = "icons/";
    private DtrPreferenceManager fManager;
    private ConfigurationManager myCfgManager;
    private static final Location LOCATION;
    IVfsActionListener _actionListener = new IVfsActionListener(){

        public void onBusy(IVersionedFileSystemManager involvedManager) {
            LOCATION.debugT("_actionListener.onBusy: calling startDelayedListening on manager " + involvedManager);
            involvedManager.startDelayedListening();
        }

        public void onIdle(IVersionedFileSystemManager[] involvedManagers) {
            LOCATION.debugT("_actionListener.onIdle");
            2 caller = this;
            int i = 0;
            while (i < involvedManagers.length) {
                IVersionedFileSystemManager involvedManager = involvedManagers[i];
                involvedManager.willCallStopDelayedListening((Object)caller);
                ++i;
            }
            Display.getDefault().asyncExec(new Runnable(this, involvedManagers, caller){
                private final /* synthetic */ IVersionedFileSystemManager[] val$involvedManagers;
                private final /* synthetic */ Object val$caller;
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = this$1;
                    this.val$involvedManagers = val$involvedManagers;
                    this.val$caller = val$caller;
                }

                public void run() {
                    if (ModalContext.getModalLevel() > 0) {
                        try {
                            BluebirdPlugin.access$000().debugT("Sleeping for 100ms");
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Display.getDefault().asyncExec((Runnable)this);
                        return;
                    }
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void run() {
                            BluebirdPlugin.access$000().debugT("_actionListener.(UI.asyncExec).run");
                            int i = 0;
                            while (i < 3.access$100(this.this$2).length) {
                                IVersionedFileSystemManager involvedManager = 3.access$100(this.this$2)[i];
                                BluebirdPlugin.access$000().debugT("_actionListener.(UI.asyncExec).stopDelayedListening for manager " + involvedManager);
                                involvedManager.stopDelayedListening(3.access$200(this.this$2));
                                ++i;
                            }
                        }
                    });
                }

                static /* synthetic */ IVersionedFileSystemManager[] access$100(3 x0) {
                    return x0.val$involvedManagers;
                }

                static /* synthetic */ Object access$200(3 x0) {
                    return x0.val$caller;
                }
            });
        }
    };
    private PluginImageRegistry _pluginImageRegistry;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$BluebirdPlugin;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$VFSAdaptableWrapper;

    public BluebirdPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        String loggingConfigFileName;
        plugin = this;
        this.initLoggerView();
        IExtension ext = descriptor.getExtension(CONFIGURATION_EXTENSION_POINT);
        if (ext != null) {
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String imagesDirectory;
                String attributeName = elements[i].getName();
                if (IMAGES_DIRECTORY_ELEMENT.equals(attributeName) && (imagesDirectory = elements[i].getAttribute(PATH_ATTTRIBUTE)) != null && !"".equals(imagesDirectory)) {
                    this.myImagesDirectory = imagesDirectory;
                    if (!this.myImagesDirectory.endsWith("/")) {
                        this.myImagesDirectory = this.myImagesDirectory + "/";
                    }
                }
                ++i;
            }
        }
        if ((loggingConfigFileName = System.getProperty("dtr.logging", "")).length() > 0) {
            File loggingConfigFile = new File(loggingConfigFileName);
            PropertiesConfigurator p = new PropertiesConfigurator(loggingConfigFile);
            p.configure();
        }
    }

    private void initLoggerView() {
        final IWorkbench workbench = this.getWorkbench();
        workbench.addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    try {
                        IViewPart viewPart = page.findView("com.tssap.dtr.client.eclipse.ui.loggerview");
                        if (viewPart == null) {
                            viewPart = page.showView("com.tssap.dtr.client.eclipse.ui.loggerview");
                            page.hideView(viewPart);
                        }
                        workbench.removeWindowListener((IWindowListener)this);
                    }
                    catch (PartInitException x) {
                        LogUtil.logException((Location)LOCATION, (Throwable)x);
                    }
                }
            }

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }
        });
    }

    public static BluebirdPlugin getDefault() {
        return plugin;
    }

    public static DAVTeamProvider getDAVTeamProvider(IResource resource) {
        if (resource.getType() == 8) {
            return null;
        }
        RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (teamProvider instanceof DAVTeamProvider) {
            return (DAVTeamProvider)teamProvider;
        }
        return null;
    }

    public void startup() throws CoreException {
        VfsActionManager.getInstance().addActionListener(this._actionListener);
        super.startup();
        VfsElementAdapterFactory factory = new VfsElementAdapterFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, class$com$tssap$dtr$client$eclipse$ui$treeBrowser$VFSAdaptableWrapper == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$VFSAdaptableWrapper = BluebirdPlugin.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.VFSAdaptableWrapper")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$VFSAdaptableWrapper);
        WorkspaceMonitor.getInstance().startupMonitor();
    }

    public void shutdown() throws CoreException {
        VfsActionManager.getInstance().removeActionListener(this._actionListener);
        super.shutdown();
        WorkspaceMonitor.getInstance().shutdownMonitor();
    }

    public PluginImageRegistry getPluginImageRegistry() {
        if (this._pluginImageRegistry == null) {
            this._pluginImageRegistry = new PluginImageRegistry(this);
        }
        return this._pluginImageRegistry;
    }

    public String getValueFromPluginDotProperties(String key) {
        try {
            return this.getDescriptor().getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public ImageDescriptor createImageDescriptor(String filename) {
        URL installURL = this.getDescriptor().getInstallURL();
        try {
            URL imageURL = new URL(installURL, this.myImagesDirectory + filename);
            return ImageDescriptor.createFromURL((URL)imageURL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getUrl(String pluginRelativeFilename) {
        if (pluginRelativeFilename == null) {
            return null;
        }
        URL installURL = this.getDescriptor().getInstallURL();
        try {
            return new URL(installURL, pluginRelativeFilename);
        }
        catch (MalformedURLException ignore) {
            LogUtil.logException((Location)LOCATION, (Throwable)ignore);
            return null;
        }
    }

    public static ViewConfigurationRegistry getViewConfigurationRegistry() {
        if (myViewConfigurationRegistry == null) {
            myViewConfigurationRegistry = new ViewConfigurationRegistry();
        }
        return myViewConfigurationRegistry;
    }

    public static IResource getResource(File file) {
        if (file == null) {
            return null;
        }
        Path resourcePath = new Path(file.getAbsolutePath());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return null;
        }
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IPath projectPath = projects[i].getLocation();
            if (projectPath.isPrefixOf((IPath)resourcePath)) {
                int segm = resourcePath.matchingFirstSegments(projectPath);
                IPath relativePath = resourcePath.removeFirstSegments(segm);
                return projects[i].findMember(relativePath);
            }
            ++i;
        }
        return null;
    }

    public boolean associateProjectWithDTR(IProject project, String clientDefName) {
        try {
            project.setSessionProperty(DAVTeamProvider.PROJECT_CONFIGURATION_PROPERTIES, (Object)clientDefName);
            RepositoryProvider.map((IProject)project, (String)PROVIDER_ID);
        }
        catch (TeamException projectAssociationProblem) {
            Logbook.getErrorChapter().println("Unable to associate project " + project.getName() + " with DTR repository (" + projectAssociationProblem.getMessage() + ")");
            LogUtil.logException((Location)LOCATION, (Throwable)projectAssociationProblem);
            return false;
        }
        catch (CoreException setPropertyFailed) {
            Logbook.getErrorChapter().println("Unable to set session property for the project: " + project.getName() + " (" + setPropertyFailed.getMessage() + ")");
            LogUtil.logException((Location)LOCATION, (Throwable)setPropertyFailed);
            return false;
        }
        return true;
    }

    public DtrPreferenceManager getPreferenceManager() {
        if (this.fManager == null) {
            this.fManager = new DtrPreferenceManager(this.getPreferenceStore());
        }
        return this.fManager;
    }

    public ConfigurationManager getCfgManager() {
        if (this.myCfgManager == null) {
            this.myCfgManager = new ConfigurationManager();
        }
        return this.myCfgManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        VfsManagerProvider.getInstance();
        myViewConfigurationRegistry = null;
        LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$BluebirdPlugin == null ? (class$com$tssap$dtr$client$eclipse$BluebirdPlugin = BluebirdPlugin.class$("com.tssap.dtr.client.eclipse.BluebirdPlugin")) : class$com$tssap$dtr$client$eclipse$BluebirdPlugin));
    }
}

