/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.ptn.common.configuration.api;

import com.sap.caf.ui.ptn.common.configuration.api.ConfigurationException;
import com.sap.caf.ui.ptn.common.configuration.api.ConfigurationToolkit;
import com.sap.caf.ui.ptn.common.configuration.api.IComponentConfigurationsManager;
import com.sap.caf.ui.ptn.common.configuration.api.IConfigurationMapAccessor;
import com.sap.tc.webdynpro.progmodel.api.IWDComponent;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import java.util.Map;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static Map getConfigurationDefaults(IWDComponent component) throws ConfigurationException {
        return ConfigurationUtils.getConfigurationDefaults(component.getDeployableObjectPart());
    }

    public static Map getConfigurationDefaults(WDDeployableObjectPart componentPart) throws ConfigurationException {
        IConfigurationMapAccessor accessor = ConfigurationToolkit.createConfigurationMapAccessor(componentPart);
        return accessor.defaults();
    }

    public static Map getConfiguration(IWDComponent component, String configName) throws ConfigurationException {
        return ConfigurationUtils.getConfiguration(component.getDeployableObjectPart(), configName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getConfiguration(WDDeployableObjectPart componentPart, String configName) throws ConfigurationException {
        IConfigurationMapAccessor accessor = ConfigurationToolkit.createConfigurationMapAccessor(componentPart);
        IComponentConfigurationsManager manager = ConfigurationToolkit.createConfigurationsManager(componentPart);
        try {
            Map serialConfig = manager.loadConfiguration(configName);
            Map map = accessor.unmarshal(serialConfig);
            return map;
        }
        finally {
            manager.release();
        }
    }
}

