/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.nameserver;

import com.sap.dictionary.tools.nameserver.NameServer;
import com.sap.dictionary.tools.nameserver.NameserverPlugin;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;

public abstract class NameServerUtil {
    public static boolean isNameReservedOnWizard(String category, String projectName, String objectName, boolean ignoreCommunicationFailure) {
        NameServer nameServer = null;
        String message = null;
        boolean communicationFailure = false;
        if (!NameServerUtil.isProjectDtrRelevant(projectName)) {
            return false;
        }
        try {
            nameServer = NameServer.getNameServer(projectName);
        }
        catch (CommunicationFailureException e) {
            message = "Could not connect to name server";
            communicationFailure = true;
        }
        if (nameServer != null) {
            try {
                if (!nameServer.isNameReserved(category, objectName)) {
                    return false;
                }
                message = "Name is already reserved. ";
            }
            catch (CommunicationFailureException e) {
                message = "Could not connect to name server";
                communicationFailure = true;
            }
        }
        if (communicationFailure && ignoreCommunicationFailure) {
            return false;
        }
        if (message != null) {
            return !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Name Reservation", (String)(message + " Do you want to continue?"));
        }
        return false;
    }

    private static boolean isProjectDtrRelevant(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return false;
        }
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)project);
        return repositoryProvider != null && repositoryProvider instanceof DAVTeamProvider;
    }

    public static boolean reservePreliminaryOnWizard(String projectName, String objectName, WizardPage page) {
        return false;
    }

    public static boolean isPrefixValidOnWizard(String category, String projectName, String objectName, WizardPage page, boolean ignoreCommunicationFailure) {
        NameServer nameServer = null;
        boolean communicationFailure = false;
        if (!NameServerUtil.isProjectDtrRelevant(projectName)) {
            return true;
        }
        try {
            nameServer = NameServer.getNameServer(projectName);
        }
        catch (CommunicationFailureException e) {
            communicationFailure = true;
        }
        if (nameServer != null) {
            try {
                if (nameServer.isPrefixValid(category, objectName)) {
                    return true;
                }
                page.setErrorMessage(objectName + ": " + "Prefix is invalid.");
                return false;
            }
            catch (CommunicationFailureException e) {
                communicationFailure = true;
            }
        }
        if (communicationFailure && !ignoreCommunicationFailure) {
            return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Name Reservation", (String)"Could not connect to name server Do you want to continue?");
        }
        return true;
    }

    public static boolean isNameServerAvailable(String projectName) {
        if (!NameServerUtil.isProjectDtrRelevant(projectName)) {
            return true;
        }
        try {
            NameServer.getNameServer(projectName);
            return true;
        }
        catch (CommunicationFailureException e) {
            NameserverPlugin.tracer.error("Coud not connect to nameserver", (Throwable)e);
            return false;
        }
    }

    public static boolean stringIsEmpty(String string) {
        return string == null || string.trim().equals("");
    }
}

