/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.nameserver;

import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.ForeignContextException;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.lcr.namealloc.api.NotOwnerException;
import java.net.MalformedURLException;
import javax.naming.CompoundName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class NameServer {
    private static NameServer mNameServer;
    private NameAllocator mNameAllocator;
    private static String mProjectName;

    private NameServer(String projectName) throws CommunicationFailureException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            this.mNameAllocator = NameServerUtil.getNameAllocator((IProject)project);
        }
        catch (MalformedURLException e) {
            throw new CommunicationFailureException("Could not connect to name server");
        }
        if (this.mNameAllocator == null) {
            throw new CommunicationFailureException("Could not connect to name server");
        }
    }

    public static NameServer getNameServer(String projectName) throws CommunicationFailureException {
        if (mNameServer == null || mProjectName == null || mProjectName != null && !mProjectName.equals(projectName)) {
            mNameServer = new NameServer(projectName);
            mProjectName = projectName;
        }
        return mNameServer;
    }

    public void reservePreliminary(String tableName) throws CommunicationFailureException, NotOwnerException, NameSyntaxViolation, ForeignContextException {
    }

    public boolean isNameReserved(String category, String objectName) throws CommunicationFailureException {
        if (this.mNameAllocator != null) {
            try {
                AllocationState allocationState = this.mNameAllocator.getAllocationState(category, objectName);
                return true;
            }
            catch (NameNotFoundException e) {
                return false;
            }
        }
        throw new CommunicationFailureException("Could not connect to name server");
    }

    public boolean isPrefixValid(String category, String objectName) throws CommunicationFailureException {
        String prefix = null;
        String compoundName = null;
        if (this.mNameAllocator == null) {
            throw new CommunicationFailureException("Could not connect to name server");
        }
        int index = objectName.indexOf("_");
        if (index == -1) {
            return false;
        }
        prefix = objectName.substring(0, index);
        CompoundName[] compoundNames = this.mNameAllocator.listAllowedPrefixes(category, true);
        int i = 0;
        while (i < compoundNames.length) {
            compoundName = compoundNames[i].toString();
            if (prefix.equals(compoundName = compoundName.substring(0, compoundName.indexOf("_")))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

