/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.nameserver;

import com.sap.dictionary.tools.nameserver.NameServerUtil;
import com.sap.dictionary.tools.nameserver.ReservationException;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.tssap.dii.dtri.DtriPropertySetter;
import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFactoryImpl;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.selena.model.elements.Element;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class DtrPropertySetter
extends DtriPropertySetter {
    public DtrPropertySetter() {
        super(null, null);
    }

    public DtriPropertySetter.Data[] createProperties(List dtrObjectList, Element element, String actionName) throws Throwable {
        IVfsFile vfsFile = null;
        String dbObjectName = null;
        Object object = null;
        String property = null;
        String message = null;
        String fileExtension = null;
        if (dtrObjectList == null || dtrObjectList != null && dtrObjectList.size() <= 0) {
            return null;
        }
        Vector<DtriPropertySetter.Data> vData = new Vector<DtriPropertySetter.Data>();
        Iterator iter = dtrObjectList.iterator();
        while (iter.hasNext()) {
            object = iter.next();
            if (!(object instanceof IVfsFile)) continue;
            vfsFile = object;
            dbObjectName = this.getDbObjectName(vfsFile);
            fileExtension = this.getFileExtension(vfsFile);
            if (dbObjectName == null && (!fileExtension.startsWith("dtdbtable") || !fileExtension.endsWith("xlf"))) continue;
            Properties properties = new Properties();
            if (dbObjectName != null) {
                if (com.sap.ide.eclipse.dii.namereservation.NameServerUtil.isNamereservationSetted((IVfsFile)vfsFile)) continue;
                try {
                    property = this.reservePreliminary(vfsFile, element, dbObjectName);
                }
                catch (Exception e) {
                    message = e.getMessage();
                    if (NameServerUtil.stringIsEmpty(message)) {
                        message = dbObjectName + ": " + "Name could not be reserved. ";
                    }
                    throw new ReservationException(message, e);
                }
                ((Hashtable)properties).put(com.sap.ide.eclipse.dii.namereservation.NameServerUtil.NAME_RESERVATION_PROPERTIY, property);
            }
            if (fileExtension.startsWith("dtdbtable")) {
                ((Hashtable)properties).put("XCM:delete-lock", "T");
            }
            DtriPropertySetter.Data data = new DtriPropertySetter.Data((Object)vfsFile, properties);
            vData.addElement(data);
        }
        if (vData.size() == 0) {
            return null;
        }
        DtriPropertySetter.Data[] aData = new DtriPropertySetter.Data[vData.size()];
        return vData.toArray(aData);
    }

    public DtriPropertySetter.Data[] removeProperties(List dtrObjectList, Element element, String actionName) throws ReservationException {
        IVfsFile vfsFile = null;
        String dbObjectName = null;
        Object object = null;
        String message = null;
        if (dtrObjectList == null || dtrObjectList != null && dtrObjectList.size() <= 0) {
            return null;
        }
        Iterator iter = dtrObjectList.iterator();
        while (iter.hasNext()) {
            object = iter.next();
            if (!(object instanceof IVfsFile) || (dbObjectName = this.getDbObjectName(vfsFile = (IVfsFile)object)) == null || !com.sap.ide.eclipse.dii.namereservation.NameServerUtil.isNamereservationSetted((IVfsFile)vfsFile)) continue;
            try {
                this.revertReservation(element, dbObjectName);
            }
            catch (Exception e) {
                message = e.getMessage();
                if (NameServerUtil.stringIsEmpty(message)) {
                    message = dbObjectName + ": " + "Reservation could not be reverted.";
                }
                throw new ReservationException(message, e);
            }
        }
        return null;
    }

    private String reservePreliminary(IVfsFile vfsFile, Element element, String dbObjectName) throws Exception {
        String projectName = null;
        IProject project = null;
        NameAllocator nameAllocator = null;
        AllocationState allocationState = null;
        String user = null;
        String reservationKey = null;
        String serverUrl = null;
        projectName = element.getModel().getUniqueName().getName();
        if (!NameServerUtil.stringIsEmpty(projectName)) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project != null) {
            nameAllocator = com.sap.ide.eclipse.dii.namereservation.NameServerUtil.getNameAllocator(project);
        }
        if (nameAllocator == null) {
            throw new ReservationException(dbObjectName + ": " + "Could not connect to name server");
        }
        try {
            allocationState = nameAllocator.getAllocationState("SAP_DBObjectName", dbObjectName);
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        if (allocationState != null && allocationState.isReserved()) {
            throw new ReservationException(dbObjectName + ": " + "Name is already reserved. ");
        }
        user = nameAllocator.getMyConnectUser();
        allocationState = nameAllocator.reservePreliminary("SAP_DBObjectName", dbObjectName, user, "Database Object Reservation", null, null, null);
        reservationKey = allocationState.getReservationKey();
        serverUrl = com.sap.ide.eclipse.dii.namereservation.NameServerUtil.getURL((NameAllocator)nameAllocator);
        if (NameServerUtil.stringIsEmpty(reservationKey) || NameServerUtil.stringIsEmpty(serverUrl)) {
            throw new ReservationException(dbObjectName + ": " + "Name could not be reserved. ");
        }
        return com.sap.ide.eclipse.dii.namereservation.NameServerUtil.createProperty((String)"SAP_DBObjectName", (String)dbObjectName, (String)reservationKey, (String)serverUrl);
    }

    private void revertReservation(Element element, String dbObjectName) throws Exception {
        NameAllocator nameAllocator = null;
        AllocationState allocationState = null;
        Object user = null;
        Object reservationKey = null;
        Object serverUrl = null;
        nameAllocator = com.sap.ide.eclipse.dii.namereservation.NameServerUtil.getNameAllocator((Element)element);
        if (nameAllocator == null) {
            throw new ReservationException(dbObjectName + ": " + "Could not connect to name server");
        }
        try {
            allocationState = nameAllocator.getAllocationState("SAP_DBObjectName", dbObjectName);
        }
        catch (NameNotFoundException e) {
            throw new ReservationException(e.getMessage(), e);
        }
        if (allocationState == null || allocationState != null && !allocationState.isReserved()) {
            return;
        }
        if (allocationState.isReservedFinally()) {
            throw new ReservationException(dbObjectName + ": " + "Name is already finally reserved, /n no reversion possible.");
        }
        if (allocationState.getReservationKey() != null) {
            try {
                nameAllocator.revert("SAP_DBObjectName", dbObjectName, allocationState.getReservationKey());
            }
            catch (NameNotFoundException e) {}
        } else {
            throw new ReservationException(dbObjectName + ": " + "The reservation key could not be acquired.");
        }
    }

    private String getDbObjectName(IVfsFile vfsFile) {
        String fileName = null;
        String dbObjectName = null;
        String fileExtension = null;
        fileName = vfsFile.getName();
        fileExtension = this.getFileExtension(vfsFile);
        if (fileExtension == null) {
            return null;
        }
        if (!fileExtension.equalsIgnoreCase("dtdbtable") && !fileExtension.equalsIgnoreCase("dtdbindex")) {
            return null;
        }
        int index = fileName.indexOf(46);
        dbObjectName = fileName.substring(0, index);
        if (NameServerUtil.stringIsEmpty(dbObjectName)) {
            return null;
        }
        return dbObjectName;
    }

    private String getFileExtension(IVfsFile vfsFile) {
        String fileName = null;
        fileName = vfsFile.getName();
        return this.getFileExtension(fileName);
    }

    private String getFileExtension(String fileName) {
        int index = fileName.indexOf(46);
        if (index != -1) {
            return fileName.substring(index + 1);
        }
        return null;
    }

    private String createDeleteLockProperty() {
        IPropertyFactory propertyFactory = PropertyFactoryImpl.getInstance();
        IProperty property = propertyFactory.createStringProperty(XCM.NAMESPACE_PREFIX, "XCM:delete-lock", "T");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = property.getAsXmlFragment(stringBuffer);
        return stringBuffer2.toString();
    }
}

