/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.ejbjar;

import com.tssap.j2ee.core.utils.StringArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EjbJarMetaInfo {
    public static final String FILE = "ejb-jar.xml";
    public static final String TRUE1 = "True";
    public static final String FALSE1 = "False";
    public static final String SPEC_VERSION_1_1 = "1.1";
    public static final String SPEC_VERSION_2_0 = "2.0";
    public static final String ACKNOWLEDGE_MODE_AUTO = "Auto-acknowledge";
    public static final String ACKNOWLEDGE_MODE_DUPS_OK = "Dups-ok-acknowledge";
    public static final String CMP_VERSION_1 = "1.x";
    public static final String CMP_VERSION_2 = "2.x";
    public static final String CMR_FIELD_TYPE_COLLECTION = "java.util.Collection";
    public static final String CMR_FIELD_TYPE_SET = "java.util.Set";
    public static final String DESTINATION_TYPE_QUEUE = "javax.jms.Queue";
    public static final String DESTINATION_TYPE_TOPIC = "javax.jms.Topic";
    public static final String METHOD_INTF_HOME = "Home";
    public static final String METHOD_INTF_REMOTE = "Remote";
    public static final String METHOD_INTF_LOCAL_HOME = "LocalHome";
    public static final String METHOD_INTF_LOCAL = "Local";
    public static final String METHOD_INTF_UNSPECIFIED = "*";
    public static final Set METHOD_INTERFACES;
    public static final String METHOD_NAME_UNSPECIFIED = "*";
    public static final String METHOD_PARAMS_UNSPECIFIED = "*";
    public static final String MULTIPLICITY_ONE = "One";
    public static final String MULTIPLICITY_MANY = "Many";
    public static final String PERSISTENCE_TYPE_BEAN = "Bean";
    public static final String PERSISTENCE_TYPE_CONTAINER = "Container";
    public static final String RESULT_TYPE_MAPPING_LOCAL = "Local";
    public static final String RESULT_TYPE_MAPPING_REMOTE = "Remote";
    public static final String SESSION_TYPE_STATEFUL = "Stateful";
    public static final String SESSION_TYPE_STATELESS = "Stateless";
    public static final String SUBSCRIPTION_DURABILITY_DURABLE = "Durable";
    public static final String SUBSCRIPTION_DURABILITY_NONDURABLE = "NonDurable";
    public static final String TRANS_ATTRIBUTE_NOT_SUPPORTED = "NotSupported";
    public static final String TRANS_ATTRIBUTE_SUPPORTS = "Supports";
    public static final String TRANS_ATTRIBUTE_REQUIRED = "Required";
    public static final String TRANS_ATTRIBUTE_REQUIRES_NEW = "RequiresNew";
    public static final String TRANS_ATTRIBUTE_MANDATORY = "Mandatory";
    public static final String TRANS_ATTRIBUTE_NEVER = "Never";
    public static final Set TRANSACTION_ATTRIBUTES;
    public static final String TRANSACTION_TYPE_BEAN = "Bean";
    public static final String TRANSACTION_TYPE_CONTAINER = "Container";
    private static final String EJB_PREFIX = "ejb";
    private static final String EJB_HOME_PREFIX = "ejbHome";
    private static final String EJB_SELECT_PREFIX = "ejbSelect";
    public static final String ABSTRACT_SCHEMA_NAME_DDP = "defaultAbstractSchemaName";
    public static final String ACKNOWLEDGE_MODE_DDP = "defaultAcknowledgeMode";
    public static final String ASSOCIATES_DDP = "@associates";
    public static final String CASCADE_DELETE_DDP = "defaultCascadeDelete";
    public static final String CMP_VERSION_DDP = "defaultCmpVersion";
    public static final String DESCRIPTION_DDP = "defaultDescription";
    public static final String DESTINATION_TYPE_DDP = "defaultDestinationType";
    public static final String DISPLAY_NAME_DDP = "defaultDisplayName";
    public static final String EJB_QL_DDP = "defaultEjbQl";
    public static final String EJB_QL_DESCRIPTION_DDP = "defaultEjbQlDescription";
    public static final String EJB_RELATION_DDP = "defaultEjbRelation";
    public static final String EJB_RELATION_TARGET_BEAN_CLASS_DDP = "defaultEjbRelationTargetBeanClass";
    public static final String EJB_RELATION_TARGET_EJB_NAME_DDP = "defaultEjbRelationTargetEjbName";
    public static final String EJB_RELATION_TARGET_LOCAL_INTERFACE_DDP = "defaultEjbRelationTargetLocalInterface";
    public static final String EJB_RELATIONSHIP_ROLE_DDP = "defaultEjbRelationshipRole";
    public static final String EXCLUDE_DDP = "defaultExclude";
    public static final String EXTERNAL_CASCADE_DELETE_DDP = "defaultExternalCascadeDelete";
    public static final String EXTERNAL_EJB_RELATIONSHIP_ROLE_DDP = "defaultExternalEjbRelationshipRole";
    public static final String EXTERNAL_MULTIPLICITY_DDP = "defaultExternalMultiplicity";
    public static final String LARGE_ICON_DDP = "defaultLargeIcon";
    public static final String MESSAGE_SELECTOR_DDP = "defaultMessageSelector";
    public static final String REENTRANT_DDP = "defaultReentrant";
    public static final String RESULT_TYPE_MAPPING_DDP = "defaultResultTypeMapping";
    public static final String RUN_AS_DDP = "defaultRunAsIdentity";
    public static final String SECURITY_ROLE_REFS_DDP = "defaultSecurityRoleRefs";
    public static final String SECURITY_ROLES_DDP = "defaultSecurityRoles";
    public static final String SMALL_ICON_DDP = "defaultSmallIcon";
    public static final String STATELESS_DDP = "defaultStateless";
    public static final String SUBSCRIPTION_DURABILITY_DDP = "defaultSubscriptionDurability";
    public static final String TRANSACTION_ATTRIBUTE_DDP = "defaultTransactionAttribute";
    public static final String TRANSACTION_TYPE_DDP = "defaultTransactionType";
    public static final String UNCHECKED_DDP = "defaultUnchecked";

    private EjbJarMetaInfo() {
    }

    public static String toString1(boolean b) {
        return b ? TRUE1 : FALSE1;
    }

    public static boolean isValidAcknowledgeMode(String mode) {
        if (mode == null) {
            return true;
        }
        if (ACKNOWLEDGE_MODE_AUTO.equals(mode)) {
            return true;
        }
        return ACKNOWLEDGE_MODE_DUPS_OK.equals(mode);
    }

    public static boolean isValidCmpVersion(String version) {
        if (version == null) {
            return true;
        }
        if (CMP_VERSION_1.equals(version)) {
            return true;
        }
        return CMP_VERSION_2.equals(version);
    }

    public static boolean isValidCmrFieldType(String type) {
        if (type == null) {
            return true;
        }
        if (CMR_FIELD_TYPE_COLLECTION.equals(type)) {
            return true;
        }
        return CMR_FIELD_TYPE_SET.equals(type);
    }

    public static boolean isValidDestinationType(String type) {
        if (type == null) {
            return false;
        }
        if (DESTINATION_TYPE_QUEUE.equals(type)) {
            return true;
        }
        return DESTINATION_TYPE_TOPIC.equals(type);
    }

    public static boolean isValidMultiplicity(String multiplicity) {
        if (multiplicity == null) {
            return false;
        }
        if (MULTIPLICITY_ONE.equals(multiplicity)) {
            return true;
        }
        return MULTIPLICITY_MANY.equals(multiplicity);
    }

    public static boolean isValidPersistenceType(String type) {
        if (type == null) {
            return false;
        }
        if ("Bean".equals(type)) {
            return true;
        }
        return "Container".equals(type);
    }

    public static boolean isValidResultTypeMapping(String type) {
        if (type == null) {
            return true;
        }
        if ("Local".equals(type)) {
            return true;
        }
        return "Remote".equals(type);
    }

    public static boolean isValidSessionType(String type) {
        if (type == null) {
            return false;
        }
        if (SESSION_TYPE_STATEFUL.equals(type)) {
            return true;
        }
        return SESSION_TYPE_STATELESS.equals(type);
    }

    public static boolean isValidSubscriptionDurability(String durability) {
        if (durability == null) {
            return true;
        }
        if (SUBSCRIPTION_DURABILITY_DURABLE.equals(durability)) {
            return true;
        }
        return SUBSCRIPTION_DURABILITY_NONDURABLE.equals(durability);
    }

    public static boolean isValidTransactionAttribute(String attribute) {
        if (attribute == null) {
            return false;
        }
        return TRANSACTION_ATTRIBUTES.contains(attribute);
    }

    public static boolean isValidTransactionType(String type) {
        if (type == null) {
            return false;
        }
        if ("Bean".equals(type)) {
            return true;
        }
        return "Container".equals(type);
    }

    public static String getMethodSignature(String ejbName, String interfaceType, String name, String[] parameters) {
        if (ejbName == null || ejbName.trim().length() == 0) {
            return null;
        }
        String baseName = EjbJarMetaInfo.getMethodSignature(interfaceType, name, parameters);
        if (baseName == null) {
            return null;
        }
        return ejbName + '.' + baseName;
    }

    public static String getMethodSignature(String interfaceType, String name, String[] parameters) {
        String baseName;
        if (interfaceType != null) {
            if (!METHOD_INTERFACES.contains(interfaceType)) {
                return null;
            }
        } else {
            interfaceType = "*";
        }
        if ((baseName = EjbJarMetaInfo.getMethodSignature(name, parameters)) == null) {
            return null;
        }
        return interfaceType + '.' + baseName;
    }

    public static String getMethodSignature(String name, String[] parameters) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        StringBuffer signature = new StringBuffer(name);
        signature.append('(');
        signature.append(EjbJarMetaInfo.getMethodParametersAsString(parameters));
        signature.append(')');
        return signature.toString();
    }

    public static String getMethodParametersAsString(String[] parameters) {
        if (parameters == null) {
            return "*";
        }
        if (parameters.length == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < parameters.length) {
            String parameter = parameters[i];
            if (parameter != null) {
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(parameter);
            }
            ++i;
        }
        return str.toString();
    }

    public static String[] getMethodSignature(String signature) {
        if (signature == null) {
            return null;
        }
        if ((signature = signature.trim()).length() == 0) {
            return null;
        }
        if (!signature.endsWith(")")) {
            return null;
        }
        int ps = signature.indexOf(40);
        if (ps < 0) {
            return null;
        }
        String namesStr = signature.substring(0, ps).trim();
        if (namesStr.length() == 0) {
            return null;
        }
        StringArrayList names = StringArrayList.getValuesAsList((String)namesStr, (String)".", (int)-1);
        if (names.isEmpty() || names.size() > 3) {
            return null;
        }
        int namesOffset = 3 - names.size();
        String parametersStr = signature.substring(ps + 1, signature.length() - 1).trim();
        StringArrayList parameters = parametersStr.length() == 0 ? StringArrayList.EMPTY_LIST : StringArrayList.getValuesAsList((String)parametersStr, (String)",", (int)-1);
        String[] components = new String[3 + parameters.size()];
        int i = 0;
        while (i < names.size()) {
            int j;
            String name = names.getString(i);
            if ("".equals(name)) {
                name = null;
            }
            if ((j = namesOffset + i) == 1) {
                if ("*".equals(name)) {
                    name = null;
                } else if (!METHOD_INTERFACES.contains(name)) {
                    return null;
                }
            }
            components[j] = name;
            ++i;
        }
        int i2 = 0;
        while (i2 < parameters.size()) {
            components[i2 + 3] = parameters.getString(i2);
            ++i2;
        }
        return components;
    }

    public static String getEjbMethodDeclaration(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.startsWith(EJB_SELECT_PREFIX)) {
            return name;
        }
        if (name.length() < 4 || !name.startsWith(EJB_PREFIX)) {
            return null;
        }
        if (name.startsWith(EJB_HOME_PREFIX)) {
            if (name.length() == EJB_HOME_PREFIX.length()) {
                return null;
            }
            name = name.substring(EJB_HOME_PREFIX.length());
        } else {
            name = name.substring(EJB_PREFIX.length());
        }
        name = name.length() == 1 ? name.toLowerCase() : name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }

    public static String getEjbMethodImplementation(String name, boolean home) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.startsWith(EJB_SELECT_PREFIX)) {
            return name;
        }
        name = name.length() == 1 ? name.toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
        name = home ? EJB_HOME_PREFIX + name : EJB_PREFIX + name;
        return name;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(METHOD_INTF_HOME);
        set.add("Local");
        set.add(METHOD_INTF_LOCAL_HOME);
        set.add("Remote");
        METHOD_INTERFACES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(TRANS_ATTRIBUTE_MANDATORY);
        set.add(TRANS_ATTRIBUTE_NEVER);
        set.add(TRANS_ATTRIBUTE_NOT_SUPPORTED);
        set.add(TRANS_ATTRIBUTE_REQUIRED);
        set.add(TRANS_ATTRIBUTE_REQUIRES_NEW);
        set.add(TRANS_ATTRIBUTE_SUPPORTS);
        TRANSACTION_ATTRIBUTES = Collections.unmodifiableSet(set);
    }
}

