/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.ejbjar;

import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.ejbjar.EjbRelation;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.ejbjar.EntityBean;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.ejbjar.MethodContainer;
import com.tssap.j2ee.core.ejbjar.Query;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Signature;

public class AssembledInfoFinder {
    public static EnterpriseBean[] findAssembledBeans(IEnterpriseBean bean) {
        return AssembledInfoFinder.findAssembledBeans(bean, false);
    }

    public static EnterpriseBean[] findAssembledBeans(IEnterpriseBean bean, boolean excludeReadOnly) {
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(bean.getEJBProject().getProject());
        if (possibleReferencers != null) {
            String expectedBeanClass = bean.getBeanClassName();
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                EjbJar[] dds;
                EjbJarProject project = EjbJarProject.getInstance((IProject)it.next());
                if (project == null || (dds = project.getEjbJars()) == null) continue;
                int i = 0;
                while (i < dds.length) {
                    EnterpriseBean[] beans;
                    if (!(excludeReadOnly && dds[i].getFile().isReadOnly() || (beans = dds[i].getEnterpriseBeans()) == null)) {
                        int j = 0;
                        while (j < beans.length) {
                            String beanClass = beans[j].getEjbClass();
                            if (beanClass != null && beanClass.equals(expectedBeanClass)) {
                                result.add(beans[j]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return result.toArray(new EnterpriseBean[result.size()]);
    }

    public static EjbJarProject[] findDependentAssemblyProjects(EjbProject ejbProject) {
        ArrayList<EjbJarProject> result = new ArrayList<EjbJarProject>();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(ejbProject.getProject());
        if (possibleReferencers != null) {
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                EjbJarProject project = EjbJarProject.getInstance((IProject)it.next());
                if (project == null) continue;
                result.add(project);
            }
        }
        return result.toArray(new EjbJarProject[result.size()]);
    }

    public static Method[] findAssembledMethods(IEJBMethod method) {
        return AssembledInfoFinder.findAssembledMethods(method, false);
    }

    public static Method[] findAssembledMethods(IEJBMethod method, boolean excludeReadOnly) {
        IEnterpriseBean expectedBean = (IEnterpriseBean)method.getParent();
        final String expectedBeanClassName = expectedBean.getBeanClassName();
        final String expectedMethodName = method.getNameForDD();
        final String[] expectedParameters = method.getParameterTypesForDD();
        return AssembledInfoFinder.findDeployedMethods(method, new UnaryConditionEx(){
            private EjbJar myEjbJar;

            public boolean execute(Object object) {
                Method ejbjarMethod = (Method)object;
                EnterpriseBean bean = this.myEjbJar.getEnterpriseBean(ejbjarMethod.getEjbName());
                if (bean == null) {
                    return false;
                }
                String beanClassName = bean.getEjbClass();
                if (!expectedBeanClassName.equals(beanClassName)) {
                    return false;
                }
                String methodName = ejbjarMethod.getMethodName();
                if (methodName == null) {
                    return false;
                }
                if (!methodName.equals(expectedMethodName)) {
                    return false;
                }
                String[] parameterTypes = ejbjarMethod.getMethodParameters();
                return AssembledInfoFinder.equalParameterTypes(parameterTypes, expectedParameters);
            }

            public void setEjbJar(EjbJar ejbJar) {
                this.myEjbJar = ejbJar;
            }
        }, excludeReadOnly);
    }

    public static Method[] findDeployedMethods(IEJBMethod method, UnaryConditionEx filter) {
        return AssembledInfoFinder.findDeployedMethods(method, filter, false);
    }

    public static Method[] findDeployedMethods(IEJBMethod method, UnaryConditionEx filter, boolean excludeReadOnly) {
        ArrayList result = new ArrayList();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(method.getEJBProject().getProject());
        if (possibleReferencers != null) {
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                EjbJar[] dds;
                EjbJarProject project = EjbJarProject.getInstance((IProject)it.next());
                if (project == null || (dds = project.getEjbJars()) == null) continue;
                int i = 0;
                while (i < dds.length) {
                    AssemblyDescriptor descriptor;
                    EjbJar dd = dds[i];
                    if (!(excludeReadOnly && dd.getFile().isReadOnly() || (descriptor = dd.getAssemblyDescriptor()) == null)) {
                        filter.setEjbJar(dd);
                        AssembledInfoFinder.addMethods(result, descriptor.getContainerTransactions(), filter);
                        AssembledInfoFinder.addMethods(result, descriptor.getMethodPermissions(), filter);
                        AssembledInfoFinder.addMethods(result, descriptor.getExcludeList(false), filter);
                    }
                    ++i;
                }
            }
        }
        return result.toArray(new Method[result.size()]);
    }

    private static void addMethods(ArrayList recipient, MethodContainer[] containers, UnaryConditionEx filter) {
        if (containers == null) {
            return;
        }
        int i = 0;
        while (i < containers.length) {
            AssembledInfoFinder.addMethods(recipient, containers[i], filter);
            ++i;
        }
    }

    private static void addMethods(ArrayList recipient, MethodContainer container, UnaryConditionEx filter) {
        if (container == null) {
            return;
        }
        Method[] methods = container.getMethods();
        if (methods == null) {
            return;
        }
        int i = 0;
        while (i < methods.length) {
            if (filter.execute(methods[i])) {
                recipient.add(methods[i]);
            }
            ++i;
        }
    }

    public static Query[] findAssembledQueries(IEJBMethod method) {
        return AssembledInfoFinder.findAssembledQueries(method, false);
    }

    public static Query[] findAssembledQueries(IEJBMethod method, boolean excludeReadOnly) {
        IEnterpriseBean expectedBean = (IEnterpriseBean)method.getParent();
        String expectedMethodName = method.getNameForDD();
        String[] expectedParameters = method.getParameterTypesForDD();
        ArrayList<Query> result = new ArrayList<Query>();
        EnterpriseBean[] beans = AssembledInfoFinder.findAssembledBeans(expectedBean, excludeReadOnly);
        int i = 0;
        while (i < beans.length) {
            if (!(beans[i] instanceof EntityBean)) {
                EjbJarPlugin.logWarning("Entity Bean is assembled as non-entity");
            } else {
                EntityBean entity = (EntityBean)beans[i];
                Query[] q = entity.getQueries();
                if (q != null) {
                    int j = 0;
                    while (j < q.length) {
                        String[] parameters;
                        if (expectedMethodName.equals(q[j].getMethodName()) && AssembledInfoFinder.equalParameterTypes(parameters = q[j].getMethodParameters(), expectedParameters)) {
                            result.add(q[j]);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return result.toArray(new Query[result.size()]);
    }

    private static boolean equalParameterTypes(String[] one, String[] another) {
        if (one == null) {
            return false;
        }
        if (one.length != another.length) {
            return false;
        }
        int i = 0;
        while (i < one.length) {
            if (one[i] == null || another[i] == null) {
                return false;
            }
            if (!Signature.getSimpleName((String)one[i]).equals(Signature.getSimpleName((String)another[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static EjbRelationshipRole[] findAssembledRelations(IRelationshipEnd relation) {
        return AssembledInfoFinder.findAssembledRelations(relation, false);
    }

    public static EjbRelationshipRole[] findAssembledRelations(IRelationshipEnd sourceRelation, boolean excludeReadOnly) {
        ArrayList<EjbRelationshipRole> result = new ArrayList<EjbRelationshipRole>();
        String sourceRelationName = sourceRelation.getName();
        IEntityBean sourceBean = (IEntityBean)sourceRelation.getParent();
        EnterpriseBean[] beans = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)sourceBean, excludeReadOnly);
        if (beans != null) {
            int i = 0;
            while (i < beans.length) {
                EjbJar ejbJar;
                EjbRelation[] relations;
                EntityBean bean;
                String beanName;
                if (beans[i] instanceof EntityBean && (beanName = (bean = (EntityBean)beans[i]).getName()) != null && (relations = (ejbJar = (EjbJar)bean.getParent()).getEjbRelations()) != null) {
                    int j = 0;
                    while (j < relations.length) {
                        EjbRelationshipRole role2;
                        EjbRelation relation = relations[j];
                        EjbRelationshipRole role1 = relation.getRole1();
                        if (role1 != null && beanName.equals(role1.getSourceEjbName()) && sourceRelationName.equals(role1.getCmrFieldName())) {
                            result.add(role1);
                        }
                        if ((role2 = relation.getRole2()) != null && beanName.equals(role2.getSourceEjbName()) && sourceRelationName.equals(role2.getCmrFieldName())) {
                            result.add(role2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result.toArray(new EjbRelationshipRole[result.size()]);
    }

    public static interface UnaryConditionEx {
        public boolean execute(Object var1);

        public void setEjbJar(EjbJar var1);
    }
}

