/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.prefpages.internal;

import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.prefpages.ITabPageConfigProvider;
import com.tssap.selena.ui.prefpages.ITabPageFactory;
import com.tssap.selena.ui.prefpages.internal.TabPageFactory;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class TabPagesConfiguration
implements ITabPageConfigProvider {
    private static final String PAGE_TAG = "page";
    static final String PAGE_TAG_CLASS_ATT = "class";
    private static final String PAGE_TAG_CATEGORY_ATT = "category";
    private static final String PAGE_TAG_NAME_ATT = "name";
    private static final String PAGE_TAG_TOOLTIP_ATT = "tooltip";
    private static final String PAGE_TAG_ORDER_ATT = "order";
    private static final String PAGE_TAG_HELPID_ATT = "helpContextId";
    private final IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
    private final IExtensionPoint point;
    private final Plugin plugin;
    private final String pluginId;
    protected Map configElements = new Hashtable();

    public TabPagesConfiguration(String extensionPointName) {
        this.plugin = ChromePlugin.getInstance();
        this.pluginId = this.plugin.getDescriptor().getUniqueIdentifier();
        this.point = this.pluginRegistry.getExtensionPoint(this.pluginId, extensionPointName);
        this.load();
    }

    protected void load() {
        if (this.point == null) {
            this.plugin.getLog().log((IStatus)new Status(4, this.pluginId, 4, "Tabbed preference pages extension point not loaded.", null));
            return;
        }
        IExtension[] extensions = this.point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension currentExtension = extensions[i];
            IConfigurationElement[] tags = currentExtension.getConfigurationElements();
            int j = 0;
            while (j < tags.length) {
                IConfigurationElement currentTag = tags[j];
                if (currentTag.getName().equals(PAGE_TAG)) {
                    this.addTabbedPage(currentTag);
                }
                ++j;
            }
            ++i;
        }
        if (this.configElements.size() == 0) {
            this.plugin.getLog().log((IStatus)new Status(4, this.pluginId, 4, "No tabbed preference page configuration found.", null));
        }
    }

    private void addTabbedPage(IConfigurationElement tag) {
        TabPageFactory tabConfig;
        String category = tag.getAttribute(PAGE_TAG_CATEGORY_ATT);
        String name = tag.getAttribute(PAGE_TAG_NAME_ATT);
        String tooltip = tag.getAttribute(PAGE_TAG_TOOLTIP_ATT);
        String order = tag.getAttribute(PAGE_TAG_ORDER_ATT);
        String helpID = tag.getAttribute(PAGE_TAG_HELPID_ATT);
        TreeSet<TabPageFactory> set = (TreeSet<TabPageFactory>)this.configElements.get(category);
        if (set == null) {
            set = new TreeSet<TabPageFactory>();
            this.configElements.put(category, set);
        }
        if (set.contains(tabConfig = new TabPageFactory(tag, name, tooltip, order, helpID))) {
            String msg = "Duplicity found: \"" + name + "\" tab already added to " + category + " page. " + "Page ignored! You should rename the tab page.";
            this.plugin.getLog().log((IStatus)new Status(2, this.pluginId, 2, msg, null));
            return;
        }
        set.add(tabConfig);
        if (this.plugin.isDebugging()) {
            String msg = "Page for " + this.point.getSimpleIdentifier() + " extension point added:\n" + "    Name = \"" + name + "\"\n" + "    Class = \"" + tag.getAttribute(PAGE_TAG_CLASS_ATT) + "\"\n" + "    Category = \"" + tag.getAttribute(PAGE_TAG_CATEGORY_ATT) + "\"\n" + "    ToolTip = \"" + tooltip + "\"\n" + "    Order = \"" + order + "\"";
            this.plugin.getLog().log((IStatus)new Status(1, this.pluginId, 1, msg, null));
        }
    }

    public ITabPageFactory[] getConfigsForId(String id) {
        SortedSet set = (SortedSet)this.configElements.get(id);
        if (set == null) {
            return null;
        }
        ITabPageFactory[] array = new ITabPageFactory[set.size()];
        return set.toArray(array);
    }
}

