/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.prefpages.internal;

import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.prefpages.IPreferenceTabPage;
import com.tssap.selena.ui.prefpages.ITabPageFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TabPageFactory
implements ITabPageFactory,
Comparable {
    private IConfigurationElement configElement;
    private String name;
    private String toolTip;
    private String order;
    private String helpID;

    public TabPageFactory(IConfigurationElement tag, String name, String toolTip, String order, String helpID) {
        this.configElement = tag;
        this.name = name;
        this.toolTip = toolTip;
        this.order = order;
        this.helpID = helpID;
    }

    public IPreferenceTabPage createTabPage() {
        IPreferenceTabPage page = null;
        try {
            String helpID;
            String descr;
            page = (IPreferenceTabPage)this.configElement.createExecutableExtension("class");
            String title = page.getTitle();
            if (title == null || title.equals("")) {
                page.setTitle(this.name);
            }
            if ((descr = page.getDescription()) == null || descr.equals("")) {
                page.setDescription(this.toolTip);
            }
            if ((helpID = page.getHelpID()) == null || helpID.equals("")) {
                page.setHelpID(this.helpID);
            }
        }
        catch (CoreException e) {
            String pluginID = ChromePlugin.getInstance().getDescriptor().getUniqueIdentifier();
            ChromePlugin.getInstance().getLog().log((IStatus)new Status(4, pluginID, 4, "Tab page creation failed.", (Throwable)e));
            page = null;
        }
        return page;
    }

    public int compareTo(Object obj) {
        return this.compareTo((TabPageFactory)obj);
    }

    public int compareTo(TabPageFactory obj) {
        int compOrder;
        String s2;
        if (obj == null) {
            throw new NullPointerException();
        }
        int compNames = this.name.compareTo(obj.name);
        if (compNames == 0) {
            return 0;
        }
        String s1 = this.order;
        if (s1 == null) {
            s1 = this.name;
        }
        if ((s2 = obj.order) == null) {
            s2 = obj.name;
        }
        if ((compOrder = s1.compareTo(s2)) == 0) {
            return compNames;
        }
        return compOrder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof TabPageFactory) {
            String objName = ((TabPageFactory)obj).name;
            return this.name.equals(objName);
        }
        return false;
    }
}

