/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.prefpages;

import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.prefpages.IPreferenceTabPage;
import com.tssap.selena.ui.prefpages.ITabPageConfigProvider;
import com.tssap.selena.ui.prefpages.ITabPageFactory;
import com.tssap.selena.ui.prefpages.Messages;
import com.tssap.selena.ui.prefpages.internal.TabPagesConfiguration;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class TabbedPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static ITabPageConfigProvider provider;
    private IPreferenceTabPage[] preferencePages = null;
    private TabFolder tabFolder = null;
    private static int lastSelectedTabIndex;
    private static String lastSelectedPageId;
    private Label descriptionLabel = null;
    private Label descriptionIcon = null;
    private Control body = null;
    private Composite buttonsComposite = null;

    protected abstract String getPreferencePageId();

    public TabbedPreferencePage() {
        this(ChromePlugin.getInstance().getImageBundle().getImageDescriptor("tgsLogo"));
    }

    public TabbedPreferencePage(ImageDescriptor imgDescr) {
        ITabPageFactory[] tabConfigArray = this.getTabPagesConfigProvider().getConfigsForId(this.getPreferencePageId());
        if (tabConfigArray != null) {
            this.preferencePages = new IPreferenceTabPage[tabConfigArray.length];
            int i = 0;
            while (i < tabConfigArray.length) {
                IPreferenceTabPage page = tabConfigArray[i].createTabPage();
                Assert.isNotNull((Object)page);
                this.preferencePages[i] = page;
                ++i;
            }
            if (this.preferencePages.length == 1) {
                this.setTitle(this.removeAmpresand(this.preferencePages[0].getTitle()));
                this.setDescription(this.preferencePages[0].getDescription());
            }
        }
    }

    protected ITabPageConfigProvider getTabPagesConfigProvider() {
        if (provider == null) {
            provider = new TabPagesConfiguration("tabbedPreferencePages");
        }
        return provider;
    }

    private String removeAmpresand(String str) {
        int pos = str.indexOf(38);
        if (pos != -1) {
            return str.substring(0, pos) + str.substring(pos + 1);
        }
        return str;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.preferencePages != null && this.preferencePages.length > 0) {
            if (this.preferencePages.length == 1) {
                IPreferenceTabPage page = this.preferencePages[0];
                page.setPreferencePage(this);
                page.setContainer(this.getContainer());
                page.createControl(composite);
                this.body = page.getControl();
                if (page.getHelpID() != null) {
                    WorkbenchHelp.setHelp((Control)this.body, (String)page.getHelpID());
                }
                this.setTitle(this.removeAmpresand(page.getTitle()));
                this.setDescription(page.getDescription());
                if (!page.wantsDefaultAndApplyButtons()) {
                    this.noDefaultAndApplyButton();
                }
            } else {
                this.tabFolder = this.createTabFolder(composite);
                this.body = this.tabFolder;
                int lastSelectedTab = lastSelectedTabIndex;
                String lastSelectedPage = lastSelectedPageId;
                boolean wantsButtons = false;
                int i = 0;
                while (i < this.preferencePages.length) {
                    TabItem tabItem = new TabItem(this.tabFolder, 0);
                    IPreferenceTabPage page = this.preferencePages[i];
                    page.setPreferencePage(this);
                    page.setContainer(this.getContainer());
                    page.setTabItem(tabItem);
                    Composite tabComp = this.createTabComposite(this.tabFolder, (IPreferencePage)page);
                    page.createControl(tabComp);
                    if (page.getHelpID() != null) {
                        WorkbenchHelp.setHelp((Control)this.tabFolder, (String)page.getHelpID());
                    }
                    tabItem.setControl((Control)tabComp);
                    tabItem.setText(page.getTitle());
                    tabItem.setToolTipText(page.getDescription());
                    wantsButtons = wantsButtons || page.wantsDefaultAndApplyButtons();
                    ++i;
                }
                if (!wantsButtons) {
                    this.noDefaultAndApplyButton();
                }
                lastSelectedTabIndex = lastSelectedTab;
                lastSelectedPageId = lastSelectedPage;
            }
        } else {
            this.noDefaultAndApplyButton();
        }
        return composite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (lastSelectedPageId != null && lastSelectedPageId.equals(this.getPreferencePageId()) && 0 <= lastSelectedTabIndex && lastSelectedTabIndex < this.tabFolder.getItemCount()) {
            this.tabFolder.setSelection(lastSelectedTabIndex);
            this.tabPageSelected(lastSelectedTabIndex);
        } else if (this.tabFolder != null) {
            this.tabPageSelected(this.tabFolder.getSelectionIndex());
        }
    }

    private Composite createTabComposite(TabFolder tabFolder, IPreferencePage page) {
        Composite content = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        String description = page.getDescription();
        if (description != null) {
            Label descr = new Label(content, 64);
            descr.setFont(this.getFont());
            descr.setText(description);
            descr.setLayoutData((Object)new GridData(768));
        }
        return content;
    }

    private TabFolder createTabFolder(Composite parent) {
        final TabFolder folder = new TabFolder(parent, 128);
        folder.setLayout((Layout)new TabFolderLayout());
        GridData data = new GridData(1808);
        folder.setLayoutData((Object)data);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int oldSelection = -1;

            public void widgetSelected(SelectionEvent e) {
                int newSelection = folder.indexOf((TabItem)e.item);
                this.oldSelection = this.selectTabPage(newSelection);
                TabbedPreferencePage.this.tabPageSelected(this.oldSelection);
            }

            private int selectTabPage(int newSelection) {
                if (this.oldSelection == -1) {
                    return newSelection;
                }
                if (TabbedPreferencePage.this.preferencePages[this.oldSelection].okToLeave()) {
                    return newSelection;
                }
                folder.setSelection(this.oldSelection);
                MessageDialog dialog = new MessageDialog(TabbedPreferencePage.this.getShell(), Messages.getString("TabbedPreferencePage.Warning_3"), null, Messages.getString("TabbedPreferencePage.The_currently_displayed_page_contains_invalid_values_4"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
                return this.oldSelection;
            }
        });
        return folder;
    }

    private void tabPageSelected(int selected) {
        if (this.buttonsComposite != null) {
            boolean enable = this.preferencePages[selected].wantsDefaultAndApplyButtons();
            Control[] children = this.buttonsComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setEnabled(enable);
                ++i;
            }
        }
        this.updateApplyButton();
        this.setMessage(this.preferencePages[selected].getMessage());
        this.setErrorMessage(this.preferencePages[selected].getErrorMessage());
        lastSelectedTabIndex = selected;
        lastSelectedPageId = this.getPreferencePageId();
    }

    public boolean isValid() {
        if (this.preferencePages == null) {
            return true;
        }
        boolean valid = true;
        int i = 0;
        while (i < this.preferencePages.length) {
            valid = valid && this.preferencePages[i].isValid();
            ++i;
        }
        this.setValid(valid);
        return valid;
    }

    protected void performApply() {
        if (this.preferencePages == null) {
            return;
        }
        int selection = 0;
        if (this.tabFolder != null) {
            selection = this.tabFolder.getSelectionIndex();
        }
        this.preferencePages[selection].performApply();
    }

    protected void performDefaults() {
        if (this.preferencePages == null) {
            return;
        }
        int selection = 0;
        if (this.tabFolder != null) {
            selection = this.tabFolder.getSelectionIndex();
        }
        this.preferencePages[selection].performDefaults();
        this.updateApplyButton();
    }

    public boolean performCancel() {
        if (this.preferencePages == null) {
            return true;
        }
        boolean perform = true;
        int i = 0;
        while (i < this.preferencePages.length) {
            perform = perform && this.preferencePages[i].performCancel();
            ++i;
        }
        return perform;
    }

    public boolean performOk() {
        if (this.preferencePages == null) {
            return true;
        }
        boolean perform = true;
        int i = 0;
        while (i < this.preferencePages.length) {
            perform = perform && this.preferencePages[i].performOk();
            ++i;
        }
        return perform;
    }

    public void init(IWorkbench workbench) {
        if (this.preferencePages == null) {
            return;
        }
        int i = 0;
        while (i < this.preferencePages.length) {
            this.preferencePages[i].init(workbench);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.preferencePages == null) {
            return;
        }
        int i = 0;
        while (i < this.preferencePages.length) {
            this.preferencePages[i].dispose();
            ++i;
        }
    }

    public void updateApplyButton() {
        super.updateApplyButton();
    }

    protected Label createDescriptionLabel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.descriptionIcon = new Label(comp, 131072);
        this.descriptionIcon.setImage(this.getImage());
        this.descriptionIcon.setLayoutData((Object)new GridData(32));
        this.descriptionLabel = new Label(comp, 0);
        this.descriptionLabel.setFont(parent.getFont());
        String descr = this.getDescription();
        if (descr != null) {
            this.descriptionLabel.setText(descr);
        }
        this.descriptionLabel.setLayoutData((Object)new GridData(768));
        return null;
    }

    protected Point doComputeSize() {
        if (this.descriptionLabel != null && this.descriptionIcon != null && this.body != null) {
            Point bodySize = this.body.computeSize(-1, -1, true);
            Point iconSize = this.descriptionIcon.computeSize(-1, -1, true);
            GridData gd = (GridData)this.descriptionLabel.getLayoutData();
            gd.widthHint = bodySize.x - iconSize.x;
            this.descriptionLabel.getParent().layout(true);
        }
        return this.getControl().computeSize(-1, -1, true);
    }

    protected void contributeButtons(Composite parent) {
        this.buttonsComposite = parent;
        this.buttonsComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TabbedPreferencePage.this.buttonsComposite = null;
            }
        });
    }

    public IPreferenceTabPage[] getPreferencePages() {
        return this.preferencePages;
    }

    public void selectTabByName(String name) {
        if (this.preferencePages == null) {
            return;
        }
        int i = 0;
        while (i < this.preferencePages.length) {
            if (name.equals(this.removeAmpresand(this.preferencePages[i].getTitle()))) {
                if (this.tabFolder != null) {
                    this.tabFolder.setSelection(i);
                    this.tabPageSelected(i);
                }
                lastSelectedTabIndex = i;
                lastSelectedPageId = this.getPreferencePageId();
                return;
            }
            ++i;
        }
    }

    static {
        lastSelectedTabIndex = 0;
        lastSelectedPageId = null;
    }
}

