/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.prefpages;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;

public class StringArrayPreferenceConverter {
    private static final String DELIMITER_STR = ",";

    private StringArrayPreferenceConverter() {
    }

    public static void setDefault(IPreferenceStore store, String name, String[] value) {
        store.setDefault(name, StringArrayPreferenceConverter.getStoredRepresentation(value));
    }

    public static void setValue(IPreferenceStore store, String name, String[] value) {
        store.setValue(name, StringArrayPreferenceConverter.getStoredRepresentation(value));
    }

    public static String[] getDefaultStringArray(IPreferenceStore store, String name) {
        return StringArrayPreferenceConverter.setStoredRepresentation(store.getDefaultString(name));
    }

    public static String[] getStringArray(IPreferenceStore store, String name) {
        return StringArrayPreferenceConverter.setStoredRepresentation(store.getString(name));
    }

    private static String getStoredRepresentation(String[] value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            buf.append(value[i]);
            if (i < value.length - 1) {
                buf.append(DELIMITER_STR);
            }
            ++i;
        }
        return buf.toString();
    }

    private static String[] setStoredRepresentation(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(str, DELIMITER_STR);
        while (token.hasMoreTokens()) {
            strings.add(token.nextToken().trim());
        }
        String[] result = new String[strings.size()];
        return strings.toArray(result);
    }
}

