/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.prefpages;

import com.tssap.selena.ui.prefpages.Messages;
import com.tssap.selena.ui.prefpages.StringArrayPreferenceConverter;
import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class StringArrayFieldEditor
extends FieldEditor {
    private Table table;
    private TableViewer tableViewer;
    private IContentProvider contentProvider;
    private Composite buttons;
    private int numberOfLines;
    private boolean valueValid = true;
    private Button addButton;
    private Button removeButton;
    private int lastNewItemNumber = 1;

    protected StringArrayFieldEditor() {
    }

    public StringArrayFieldEditor(String name, Composite parent) {
        this(name, "", parent);
    }

    public StringArrayFieldEditor(String name, String headerText, Composite parent) {
        super(name, headerText, parent);
    }

    public Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 68352);
            this.table.setLinesVisible(true);
            this.table.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u007f') {
                        StringArrayFieldEditor.this.removeItem(StringArrayFieldEditor.this.table.getSelectionIndex());
                    } else if (e.keyCode == 0x1000009) {
                        StringArrayFieldEditor.this.addItem();
                    }
                }
            });
            TableLayout layout = new TableLayout();
            this.table.setLayout((Layout)layout);
            ColumnWeightData columnLayout = new ColumnWeightData(100, true);
            layout.addColumnData((ColumnLayoutData)columnLayout);
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setResizable(columnLayout.resizable);
            String headerText = this.getLabelText();
            tableColumn.setText(headerText);
            this.table.setHeaderVisible(!headerText.equals(""));
            this.tableViewer = new TableViewer(this.table);
            this.tableViewer.setUseHashlookup(true);
            this.tableViewer.setContentProvider((org.eclipse.jface.viewers.IContentProvider)this.getContentProvider());
            this.tableViewer.setInput((Object)"");
            this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.table){
                boolean initialized = false;

                public void activate() {
                    super.activate();
                    StringArrayFieldEditor.this.addButton.setEnabled(false);
                    StringArrayFieldEditor.this.removeButton.setEnabled(false);
                }

                public void deactivate() {
                    super.deactivate();
                    if (this.initialized) {
                        StringArrayFieldEditor.this.addButton.setEnabled(true);
                        StringArrayFieldEditor.this.removeButton.setEnabled(true);
                    }
                    this.initialized = true;
                }
            }});
            this.tableViewer.setColumnProperties(new String[]{Messages.getString("StringArrayFieldEditor.values_4")});
            this.tableViewer.setCellModifier(new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    return true;
                }

                public Object getValue(Object element, String property) {
                    return element;
                }

                public void modify(Object element, String property, Object value) {
                    TableItem item = (TableItem)element;
                    int tableIndex = StringArrayFieldEditor.this.table.indexOf(item);
                    StringArrayFieldEditor.this.contentProvider.set(tableIndex, value);
                    StringArrayFieldEditor.this.refreshValidState();
                    StringArrayFieldEditor.this.tableViewer.setSelection(null);
                    StringArrayFieldEditor.this.tableViewer.refresh();
                }
            });
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.table;
    }

    protected Composite getButtonsControl(Composite parent) {
        if (this.buttons == null) {
            this.buttons = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout = new GridLayout(1, true);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.buttons.setLayout((Layout)layout);
            this.addButton = new Button(this.buttons, 8);
            this.addButton.setText(Messages.getString("StringArrayFieldEditor.Add_5"));
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StringArrayFieldEditor.this.addItem();
                }
            });
            GridData gd = new GridData(768);
            this.addButton.setLayoutData((Object)gd);
            this.removeButton = new Button(this.buttons, 8);
            this.removeButton.setText(Messages.getString("StringArrayFieldEditor.Remove_6"));
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StringArrayFieldEditor.this.removeItem(StringArrayFieldEditor.this.table.getSelectionIndex());
                }
            });
            gd = new GridData(768);
            this.removeButton.setLayoutData((Object)gd);
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.buttons;
    }

    protected String generateNewItem() {
        return Messages.getString("StringArrayFieldEditor.NewItem_7") + this.lastNewItemNumber++;
    }

    private void addItem() {
        String newItem = this.generateNewItem();
        this.contentProvider.add(newItem);
        this.tableViewer.refresh();
        this.tableViewer.editElement((Object)newItem, 0);
    }

    private void removeItem(int index) {
        if (index != -1) {
            this.contentProvider.remove(index);
            this.refreshValidState();
            this.tableViewer.refresh();
            int lastindex = this.table.getItemCount() - 1;
            if (index > lastindex) {
                index = lastindex;
            }
            this.table.setSelection(index);
        }
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.numberOfLines = numberOfLines;
        ((GridData)this.table.getLayoutData()).heightHint = this.table.getItemHeight() * numberOfLines;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.table = this.getTableControl(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns - 1;
        this.numberOfLines = 4;
        gd.heightHint = this.table.getItemHeight() * this.numberOfLines;
        this.table.setLayoutData((Object)gd);
        this.buttons = this.getButtonsControl(parent);
        gd = new GridData(2);
        this.buttons.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.contentProvider.clear();
        String[] strings = StringArrayPreferenceConverter.getStringArray(this.getPreferenceStore(), this.getPreferenceName());
        int i = 0;
        while (i < strings.length) {
            this.contentProvider.add(strings[i]);
            ++i;
        }
        this.tableViewer.refresh();
    }

    protected void doLoadDefault() {
        this.contentProvider.clear();
        String[] strings = StringArrayPreferenceConverter.getDefaultStringArray(this.getPreferenceStore(), this.getPreferenceName());
        int i = 0;
        while (i < strings.length) {
            this.contentProvider.add(strings[i]);
            ++i;
        }
        this.tableViewer.refresh();
    }

    protected void doStore() {
        String[] strings = (String[])this.contentProvider.getElements(null);
        StringArrayPreferenceConverter.setValue(this.getPreferenceStore(), this.getPreferenceName(), strings);
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new StringListContentProvider();
        }
        return this.contentProvider;
    }

    public boolean isValid() {
        return this.valueValid;
    }

    protected void refreshValidState() {
        this.valueValid = this.getValidState();
        if (this.valueValid) {
            this.showErrorMessage(null);
            this.addButton.setEnabled(true);
        } else {
            this.showErrorMessage(Messages.getString("StringArrayFieldEditor.Field_editor_contains_duplicated_values._8"));
            this.addButton.setEnabled(false);
        }
        this.getPreferencePage().setValid(this.valueValid);
    }

    private boolean getValidState() {
        TreeSet<String> set = new TreeSet<String>();
        String[] strings = (String[])this.contentProvider.getElements(null);
        int i = 0;
        while (i < strings.length) {
            if (!set.add(strings[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class StringListContentProvider
    implements IContentProvider {
        private ArrayList elements = new ArrayList();

        public Object[] getElements(Object parent) {
            String[] elms = new String[this.elements.size()];
            return this.elements.toArray(elms);
        }

        public void add(Object element) {
            this.elements.add(element);
        }

        public void clear() {
            this.elements.clear();
        }

        public Object get(int index) {
            return this.elements.get(index);
        }

        public int indexOf(Object element) {
            return this.elements.indexOf(element);
        }

        public void remove(int index) {
            this.elements.remove(index);
        }

        public void set(int index, Object element) {
            this.elements.set(index, element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    protected static interface IContentProvider
    extends IStructuredContentProvider {
        public void add(Object var1);

        public void clear();

        public Object get(int var1);

        public int indexOf(Object var1);

        public void remove(int var1);

        public void set(int var1, Object var2);
    }
}

