/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.prefpages;

import com.tssap.selena.ui.prefpages.Messages;
import com.tssap.selena.ui.prefpages.StringArrayPreferenceConverter;
import java.util.ArrayList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class OrgerStringFieldEditor
extends FieldEditor {
    private Table table;
    private TableViewer tableViewer;
    private IContentProvider contentProvider;
    private Composite buttons;
    private int numberOfLines;
    private boolean valueValid = true;
    private Button addButton;
    private Button removeButton;
    private int lastNewItemNumber = 1;

    public OrgerStringFieldEditor(String name, String headerText, Composite parent) {
        super(name, headerText, parent);
    }

    public Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 68352);
            this.table.setLinesVisible(true);
            this.table.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u1000001') {
                        OrgerStringFieldEditor.this.itemUp(OrgerStringFieldEditor.this.table.getSelectionIndex());
                    } else if (e.keyCode == 0x1000002) {
                        OrgerStringFieldEditor.this.itemDown(OrgerStringFieldEditor.this.table.getSelectionIndex());
                    }
                }
            });
            TableLayout layout = new TableLayout();
            this.table.setLayout((Layout)layout);
            ColumnWeightData columnLayout = new ColumnWeightData(100, true);
            layout.addColumnData((ColumnLayoutData)columnLayout);
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setResizable(columnLayout.resizable);
            String headerText = this.getLabelText();
            tableColumn.setText(headerText);
            this.table.setHeaderVisible(!headerText.equals(""));
            this.tableViewer = new TableViewer(this.table);
            this.tableViewer.setUseHashlookup(true);
            this.tableViewer.setContentProvider((org.eclipse.jface.viewers.IContentProvider)this.getContentProvider());
            this.tableViewer.setInput((Object)"");
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.table;
    }

    protected Composite getButtonsControl(Composite parent) {
        if (this.buttons == null) {
            this.buttons = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout = new GridLayout(1, true);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.buttons.setLayout((Layout)layout);
            this.addButton = new Button(this.buttons, 8);
            this.addButton.setText(Messages.getString("OrgerStringFieldEditor.Up"));
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OrgerStringFieldEditor.this.itemUp(OrgerStringFieldEditor.this.table.getSelectionIndex());
                }
            });
            GridData gd = new GridData(768);
            this.addButton.setLayoutData((Object)gd);
            this.removeButton = new Button(this.buttons, 8);
            this.removeButton.setText(Messages.getString("OrgerStringFieldEditor.Down"));
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OrgerStringFieldEditor.this.itemDown(OrgerStringFieldEditor.this.table.getSelectionIndex());
                }
            });
            gd = new GridData(768);
            this.removeButton.setLayoutData((Object)gd);
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.buttons;
    }

    private void itemUp(int index) {
        this.contentProvider.up(index);
        this.tableViewer.refresh();
        if (index > 0) {
            this.table.setSelection(index - 1);
        }
    }

    private void itemDown(int index) {
        this.contentProvider.down(index);
        this.tableViewer.refresh();
        if (index < this.table.getItemCount() - 1) {
            this.table.setSelection(index + 1);
        }
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.numberOfLines = numberOfLines;
        ((GridData)this.table.getLayoutData()).heightHint = this.table.getItemHeight() * numberOfLines;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        result.setLayoutData((Object)gd);
        this.table = this.getTableControl(result);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.numberOfLines = 4;
        gd.heightHint = this.table.getItemHeight() * this.numberOfLines;
        this.table.setLayoutData((Object)gd);
        this.buttons = this.getButtonsControl(result);
        gd = new GridData(2);
        gd.horizontalSpan = 1;
        this.buttons.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.contentProvider.clear();
        String[] strings = StringArrayPreferenceConverter.getStringArray(this.getPreferenceStore(), this.getPreferenceName());
        int i = 0;
        while (i < strings.length) {
            this.contentProvider.add(strings[i]);
            ++i;
        }
        this.tableViewer.refresh();
    }

    protected void doLoadDefault() {
        this.contentProvider.clear();
        String[] strings = StringArrayPreferenceConverter.getDefaultStringArray(this.getPreferenceStore(), this.getPreferenceName());
        int i = 0;
        while (i < strings.length) {
            this.contentProvider.add(strings[i]);
            ++i;
        }
        this.tableViewer.refresh();
    }

    protected void doStore() {
        String[] strings = (String[])this.contentProvider.getElements(null);
        StringArrayPreferenceConverter.setValue(this.getPreferenceStore(), this.getPreferenceName(), strings);
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new StringListContentProvider();
        }
        return this.contentProvider;
    }

    private class StringListContentProvider
    implements IContentProvider {
        private ArrayList elements = new ArrayList();

        public Object[] getElements(Object parent) {
            String[] elms = new String[this.elements.size()];
            return this.elements.toArray(elms);
        }

        public void add(Object element) {
            this.elements.add(element);
        }

        public void up(int index) {
            if (index > 0 && index < this.elements.size()) {
                Object obj = this.elements.remove(index);
                this.elements.add(index - 1, obj);
            }
        }

        public void down(int index) {
            if (index >= 0 && index < this.elements.size() - 1) {
                Object obj = this.elements.remove(index);
                this.elements.add(index + 1, obj);
            }
        }

        public void clear() {
            this.elements.clear();
        }

        public Object get(int index) {
            return this.elements.get(index);
        }

        public int indexOf(Object element) {
            return this.elements.indexOf(element);
        }

        public void remove(int index) {
            this.elements.remove(index);
        }

        public void set(int index, Object element) {
            this.elements.set(index, element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    protected static interface IContentProvider
    extends IStructuredContentProvider {
        public void add(Object var1);

        public void up(int var1);

        public void down(int var1);

        public void clear();

        public Object get(int var1);

        public int indexOf(Object var1);

        public void remove(int var1);

        public void set(int var1, Object var2);
    }
}

