/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal.debug;

import com.tssap.selena.ui.internal.debug.Messages;
import java.text.NumberFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MemoryUsageDialog
extends Dialog {
    private static long myMemoryUsage;
    private Label myUsageText;
    private Label myTotalText;
    private Label myFreeText;
    private Label myUPSText;
    private static final int RUN_GC_INDEX = 10;
    private static final String RUN_GC_LABEL;
    private static final String MARK_LABEL;
    private static final String KB;
    private static final String PER_SECOND = "";
    private static double ourUPS;
    private static int ourUPSCount;
    private static final int MARK_INDEX = 11;

    public MemoryUsageDialog(Shell parentShell) {
        super(parentShell);
    }

    public static void setUPS(double ups) {
        if (ups > 0.0) {
            ourUPS += ups;
            ++ourUPSCount;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, RUN_GC_LABEL, false);
        this.createButton(parent, 11, MARK_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Group grid = new Group(parent, 0);
        grid.setLayout((Layout)new GridLayout(3, true));
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        grid.setLayoutData((Object)data);
        Label total = new Label((Composite)grid, 0);
        total.setText(Messages.getString("MemoryUsageDialog.Total_1"));
        this.myTotalText = new Label((Composite)grid, 0);
        Label kb = new Label((Composite)grid, 0);
        kb.setText(KB);
        Label free = new Label((Composite)grid, 0);
        free.setText(Messages.getString("MemoryUsageDialog.Free_2"));
        this.myFreeText = new Label((Composite)grid, 0);
        kb = new Label((Composite)grid, 0);
        kb.setText(KB);
        Label used = new Label((Composite)grid, 0);
        used.setText(Messages.getString("MemoryUsageDialog.Used_3"));
        this.myUsageText = new Label((Composite)grid, 0);
        kb = new Label((Composite)grid, 0);
        kb.setText(KB);
        Label ups = new Label((Composite)grid, 0);
        ups.setText(Messages.getString("MemoryUsageDialog.UPS_4"));
        this.myUPSText = new Label((Composite)grid, 0);
        kb = new Label((Composite)grid, 0);
        kb.setText(PER_SECOND);
        this.updateUsage();
        return parent;
    }

    protected void updateUsage() {
        long difference;
        long currentUsage = this.getCurrentMemoryUsage();
        long l = difference = myMemoryUsage == 0L ? 0L : currentUsage - myMemoryUsage;
        if (this.myUsageText != null && !this.myUsageText.isDisposed()) {
            String text = PER_SECOND + currentUsage / 1024L;
            text = text + " (" + difference / 1024L + ")";
            if (difference > 0L && myMemoryUsage != 0L) {
                this.myUsageText.setForeground(new Color(null, 255, 0, 0));
            } else {
                this.myUsageText.setForeground(new Color(null, 0, 0, 255));
            }
            this.myUsageText.setText(text);
            this.myTotalText.setText(PER_SECOND + Runtime.getRuntime().totalMemory() / 1024L);
            this.myFreeText.setText(PER_SECOND + Runtime.getRuntime().freeMemory() / 1024L);
            this.myUPSText.setText(this.getUPS());
            this.myUsageText.getParent().layout();
        }
    }

    protected void buttonPressed(int index) {
        if (index == 10) {
            System.gc();
            ourUPS = 0.0;
            ourUPSCount = 0;
            this.updateUsage();
            return;
        }
        if (index == 11) {
            myMemoryUsage = this.getCurrentMemoryUsage();
            this.updateUsage();
            return;
        }
        super.buttonPressed(index);
    }

    public long getMemoryUsage() {
        return myMemoryUsage;
    }

    protected String getUPS() {
        if (ourUPSCount == 0) {
            return Messages.getString("MemoryUsageDialog.unknown__(0)_10");
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        return nf.format(ourUPS / (double)ourUPSCount).toString() + " (" + ourUPSCount + ")";
    }

    private long getCurrentMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (newShell != null) {
            this.setBlockOnOpen(false);
            newShell.setText(Messages.getString("MemoryUsageDialog.Memory_Usage_17"));
            newShell.setImage(JFaceResources.getImage((String)"dialog_info_image"));
            this.setShellStyle(newShell.getStyle() | 0x10);
        }
    }

    static {
        RUN_GC_LABEL = Messages.getString("MemoryUsageDialog.Run_GC_13");
        MARK_LABEL = Messages.getString("MemoryUsageDialog.Mark_14");
        KB = Messages.getString("MemoryUsageDialog.KB_15");
        ourUPS = 0.0;
        ourUPSCount = 0;
    }
}

