/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal.celleditor;

import com.tssap.selena.ui.internal.celleditor.Messages;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableDialog
extends Dialog {
    protected Table table;
    protected TableViewer tableViewer;
    protected TableEditor editor;
    protected ContentProvider contentProvider;
    private Button add;
    private Button remove;
    private String myTitle;

    public TableDialog(Shell parent, String title) {
        super(parent);
        this.setShellStyle(67696);
        this.myTitle = title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.myTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (0 == buttonId) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else {
            this.buttonPressed(buttonId);
        }
    }

    public boolean close() {
        if (this.isEditorActivated()) {
            return false;
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        Composite pane = this.createButtonsControl(composite);
        this.createTableControl(composite);
        return composite;
    }

    private Composite createButtonsControl(Composite parent) {
        Composite pane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pane.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        pane.setLayoutData((Object)gd);
        Composite emptyPane = new Composite(pane, 0);
        gd = new GridData(768);
        gd.heightHint = 0;
        gd.widthHint = 0;
        emptyPane.setLayoutData((Object)gd);
        Composite buttonsPane = new Composite(pane, 0);
        gd = new GridData(4);
        gd.horizontalAlignment = 3;
        buttonsPane.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 3;
        buttonsPane.setLayout((Layout)layout);
        this.add = new Button(buttonsPane, 8);
        this.add.setText(Messages.getString("TableDialog.Add_1"));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = TableDialog.this.table.getSelectionIndex();
                TableItem[] items = TableDialog.this.table.getItems();
                int newPos = items.length;
                TableDialog.this.addRow(newPos);
                TableDialog.this.refreshViewer();
                TableDialog.this.table.setFocus();
                TableDialog.this.table.setSelection(newPos);
                TableDialog.this.edit(-1);
            }
        });
        gd = new GridData(768);
        this.add.setLayoutData((Object)gd);
        this.remove = new Button(buttonsPane, 8);
        this.remove.setText(Messages.getString("TableDialog.Remove_2"));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = TableDialog.this.table.getSelectionIndex();
                if (index != -1) {
                    TableDialog.this.removeRow(index);
                    TableDialog.this.table.setFocus();
                    TableDialog.this.refreshViewer();
                    index = --index > 0 ? index : 0;
                    TableDialog.this.table.setSelection(index);
                }
            }
        });
        gd = new GridData(768);
        this.remove.setLayoutData((Object)gd);
        return pane;
    }

    private void createTableControl(Composite parent) {
        this.table = new Table(parent, 68352);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 200;
        this.table.setLayoutData((Object)gd);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        String[] columnHeaders = this.getColumnHeaders();
        ColumnLayoutData[] columnLayouts = this.getColumnLayouts();
        int i = 0;
        while (i < columnHeaders.length) {
            layout.addColumnData(columnLayouts[i]);
            TableColumn tableColumn = new TableColumn(this.table, 0, i);
            tableColumn.setResizable(columnLayouts[i].resizable);
            tableColumn.setText(columnHeaders[i]);
            ++i;
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    TableDialog.this.edit(e.x);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    TableDialog.this.edit(e.x);
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.contentProvider = this.getContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.tableViewer.setInput((Object)"");
        this.editor = new TableEditor(this.table);
    }

    private void edit(int x) {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        int column = this.getColumn(x);
        int row = this.table.getSelectionIndex();
        this.setEditControl(this.table, this.editor, row, column);
    }

    protected void refreshViewer() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.tableViewer.refresh();
    }

    private int getColumn(int x) {
        if (x == -1) {
            return 0;
        }
        int overallLength = 0;
        TableColumn[] columns = this.table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (x >= (overallLength += columns[i].getWidth()) - columns[i].getWidth() && x < overallLength) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected abstract String[] getColumnHeaders();

    protected abstract ColumnLayoutData[] getColumnLayouts();

    protected abstract void setEditControl(Table var1, TableEditor var2, int var3, int var4);

    protected abstract boolean isEditorActivated();

    public abstract Object[] getValues();

    public abstract void setValues(Object[] var1);

    protected abstract void addRow(int var1);

    protected abstract void removeRow(int var1);

    protected abstract ITableLabelProvider getLabelProvider();

    protected abstract ContentProvider getContentProvider();

    protected class GenericContentProvider
    implements ContentProvider {
        protected Vector elements = new Vector();

        public Object[] getElements(Object parent) {
            Object[] elms = new Object[this.elements.size()];
            return this.elements.toArray(elms);
        }

        public void add(Object element) {
            this.elements.add(element);
        }

        public Object get(int index) {
            return this.elements.get(index);
        }

        public void replace(Object element, int index) {
            this.elements.remove(index);
            this.elements.insertElementAt(element, index);
        }

        public void remove(Object element) {
            this.elements.remove(element);
        }

        public void remove(int index) {
            this.elements.remove(index);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        private void dump() {
            int i = 0;
            while (i < this.elements.size()) {
                System.out.println("element " + this.elements.get(i));
                ++i;
            }
        }
    }

    protected static interface ContentProvider
    extends IStructuredContentProvider {
        public void add(Object var1);

        public Object get(int var1);

        public void replace(Object var1, int var2);

        public void remove(Object var1);

        public void remove(int var1);
    }
}

