/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal.celleditor;

import com.tssap.selena.ui.internal.celleditor.OneColumnTableDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class StereotypeTableDialog
extends OneColumnTableDialog {
    private boolean cellEditorActivated = false;
    private String[] stereotypes = new String[0];

    public StereotypeTableDialog(Shell parent, String title) {
        super(parent, title);
    }

    protected void setEditControl(Table table, final TableEditor editor, final int row, final int column) {
        if (row == -1) {
            return;
        }
        TableItem item = table.getItem(row);
        if (item == null) {
            return;
        }
        final CCombo comboBox = new CCombo((Composite)table, 0);
        final String oldText = item.getText();
        comboBox.setText(oldText);
        int i = 0;
        while (i < this.stereotypes.length) {
            block5: {
                String[] comboItems = comboBox.getItems();
                int j = 0;
                while (j < comboItems.length) {
                    if (this.stereotypes[i].compareTo(comboItems[j]) < 0) {
                        comboBox.add(this.stereotypes[i], j);
                        break block5;
                    }
                    ++j;
                }
                comboBox.add(this.stereotypes[i]);
            }
            ++i;
        }
        comboBox.setText(oldText);
        comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                StereotypeTableDialog.this.cellEditorActivated = true;
            }

            public void focusLost(FocusEvent e) {
                StereotypeTableDialog.this.acceptChanges(comboBox.getText(), oldText, row, column);
                StereotypeTableDialog.this.cellEditorActivated = false;
            }
        });
        comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    StereotypeTableDialog.this.acceptChanges(comboBox.getText(), oldText, row, column);
                    StereotypeTableDialog.this.cellEditorActivated = false;
                } else if (e.keyCode == 27) {
                    StereotypeTableDialog.this.cellEditorActivated = false;
                    editor.getEditor().dispose();
                }
            }
        });
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        editor.setEditor((Control)comboBox, item, 0);
        comboBox.setFocus();
    }

    public void setStereotypes(String[] stereotypes) {
        this.stereotypes = stereotypes;
    }

    public String[] getStereotypes() {
        return this.stereotypes;
    }
}

