/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal.celleditor;

import com.tssap.selena.ui.internal.celleditor.Messages;
import com.tssap.selena.ui.internal.celleditor.TableDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class OneColumnTableDialog
extends TableDialog {
    private String[] columnHeaders = new String[]{Messages.getString("OneColumnTableDialog.Values_1")};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, true)};
    private boolean cellEditorActivated = false;
    private TableDialog.ContentProvider contentProvider = new MyContentProvider();

    protected OneColumnTableDialog(Shell parent, String title) {
        super(parent, title);
    }

    protected void setEditControl(Table table, TableEditor editor, int row, int column) {
    }

    public Object[] getValues() {
        return this.contentProvider.getElements(null);
    }

    public void setValues(Object[] values) {
        if (values == null) {
            return;
        }
        int i = 0;
        while (i < values.length) {
            this.contentProvider.add(values[i]);
            ++i;
        }
    }

    protected TableDialog.ContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new MyLabelProvider();
    }

    protected void addRow(int row) {
        this.contentProvider.add("");
    }

    protected void removeRow(int row) {
        this.contentProvider.remove(row);
    }

    protected void acceptChanges(String newText, String oldText, int row, int column) {
        if (!newText.equals(oldText)) {
            this.contentProvider.replace(newText, row);
            this.refreshViewer();
        }
    }

    protected boolean isEditorActivated() {
        return this.cellEditorActivated;
    }

    protected String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    protected ColumnLayoutData[] getColumnLayouts() {
        return this.columnLayouts;
    }

    private class MyContentProvider
    extends TableDialog.GenericContentProvider {
        private MyContentProvider() {
            super(OneColumnTableDialog.this);
        }

        public Object[] getElements(Object parent) {
            String[] elms = new String[this.elements.size()];
            return this.elements.toArray(elms);
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }
    }
}

