/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal.celleditor;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditableComboBoxCellEditor
extends CellEditor {
    private String[] myDisplayItems;
    private Object[] myItems;
    private String myDefaultItem;
    private CCombo comboBox;

    public EditableComboBoxCellEditor(Composite parent, String[] displayItems, Object[] items, String defaultItem) {
        super(parent);
        Assert.isNotNull((Object)items);
        this.myItems = items;
        this.myDisplayItems = displayItems;
        this.myDefaultItem = defaultItem;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        return this.createControl(parent, false);
    }

    protected Control createControl(Composite parent, boolean readOnly) {
        int flags = readOnly ? 8 : 0;
        this.comboBox = new CCombo(parent, flags);
        this.comboBox.setBackground(parent.getBackground());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                EditableComboBoxCellEditor.super.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                int index = EditableComboBoxCellEditor.this.comboBox.getSelectionIndex();
                if (index >= 0) {
                    Object newValue = EditableComboBoxCellEditor.this.findValue(EditableComboBoxCellEditor.this.comboBox.getItem(index));
                    EditableComboBoxCellEditor.super.valueChanged(EditableComboBoxCellEditor.this.isValueValid(), EditableComboBoxCellEditor.super.isCorrect(newValue));
                    EditableComboBoxCellEditor.this.doSetValue(newValue);
                }
                EditableComboBoxCellEditor.super.fireApplyEditorValue();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected Object doGetValue() {
        return this.findValue(this.comboBox.getText());
    }

    protected void doSetValue(Object value) {
        if (value != null) {
            this.comboBox.setText(this.findDisplayValue(value));
        } else if (this.myDefaultItem != null) {
            this.comboBox.setText(this.findDisplayValue(this.myDefaultItem));
        }
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.myDisplayItems != null) {
            int i = 0;
            while (i < this.myDisplayItems.length) {
                this.comboBox.add(this.myDisplayItems[i], i);
                ++i;
            }
            this.setValueValid(true);
        }
    }

    private Object findValue(String displayValue) {
        int i = 0;
        while (i < this.myDisplayItems.length) {
            if (this.myDisplayItems[i].equals(displayValue)) {
                return this.myItems[i];
            }
            ++i;
        }
        return displayValue;
    }

    private String findDisplayValue(Object value) {
        int i = 0;
        while (i < this.myItems.length) {
            if (this.myItems[i] == value || this.myItems[i] != null && this.myItems[i].equals(value)) {
                return this.myDisplayItems[i];
            }
            ++i;
        }
        return value.toString();
    }
}

