/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal.celleditor;

import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.ui.internal.celleditor.OneColumnTableDialog;
import com.tssap.selena.ui.prefpages.StringArrayPreferenceConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AuthorTableDialog
extends OneColumnTableDialog {
    private boolean cellEditorActivated = false;
    private String[] authors = new String[0];

    public AuthorTableDialog(Shell parent, String title) {
        super(parent, title);
        IPreferenceStore store = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
        this.authors = StringArrayPreferenceConverter.getStringArray(store, "author");
    }

    protected void setEditControl(Table table, final TableEditor editor, final int row, final int column) {
        if (row == -1) {
            return;
        }
        TableItem item = table.getItem(row);
        if (item == null) {
            return;
        }
        final CCombo comboBox = new CCombo((Composite)table, 0);
        final String oldText = item.getText();
        comboBox.setText(oldText);
        int i = 0;
        while (i < this.authors.length) {
            comboBox.add(this.authors[i], i);
            ++i;
        }
        comboBox.setText(oldText);
        comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AuthorTableDialog.this.cellEditorActivated = true;
            }

            public void focusLost(FocusEvent e) {
                AuthorTableDialog.this.acceptChanges(comboBox.getText(), oldText, row, column);
                AuthorTableDialog.this.cellEditorActivated = false;
            }
        });
        comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AuthorTableDialog.this.acceptChanges(comboBox.getText(), oldText, row, column);
                    AuthorTableDialog.this.cellEditorActivated = false;
                } else if (e.keyCode == 27) {
                    AuthorTableDialog.this.cellEditorActivated = false;
                    editor.getEditor().dispose();
                }
            }
        });
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        editor.setEditor((Control)comboBox, item, 0);
        comboBox.setFocus();
    }

    protected void acceptChanges(String newText, String oldText, int row, int column) {
        super.acceptChanges(newText, oldText, row, column);
    }

    public void setAuthors(String[] authors) {
        this.authors = authors;
    }

    public String[] getAuthors() {
        return this.authors;
    }
}

