/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.IPropertyMarshaler;
import java.util.StringTokenizer;

public class StringArrayMarshaler
implements IPropertyMarshaler {
    private static final String DELIMITERS = ",";

    public String marshal(Object value) {
        if (value instanceof Object[]) {
            return this.marshal((Object[])value);
        }
        throw new IllegalArgumentException("StringArrayMarshaler could not marshal value:" + value);
    }

    private String marshal(Object[] elements) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            sbuf.append(elements[i].toString()).append(DELIMITERS);
            ++i;
        }
        int length = sbuf.length();
        if (length > 0) {
            sbuf.setLength(length - DELIMITERS.length());
        }
        return sbuf.toString();
    }

    public Object unmarshal(String value) {
        StringTokenizer st = new StringTokenizer(value, DELIMITERS);
        int count = st.countTokens();
        String[] values = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            values[i] = st.nextToken().trim();
            ++i;
        }
        return values;
    }
}

