/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.internal.DoNotSortMenuManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class SortingMenuManager
extends MenuManager {
    private static final char LARGEST_CHAR_SEQ = '\uffff';
    private static final String LARGEST_ID = new String(new char[]{'\uffff'});

    protected void update(boolean force, boolean recursive) {
        this.sortMenuItems(true);
        super.update(force, recursive);
    }

    protected void sortMenuItems(boolean recursive) {
        SortingMenuManager.sortMenuItems((IMenuManager)this, recursive);
    }

    protected static void sortMenuItems(IMenuManager menu, boolean recursive) {
        IContributionItem[] items = menu.getItems();
        List groupMarkerPositions = SortingMenuManager.getGroupMarkerPositions(items);
        int i = 0;
        while (i < groupMarkerPositions.size() - 1) {
            SortingMenuManager.sortMenuItems(menu, items, (Integer)groupMarkerPositions.get(i), (Integer)groupMarkerPositions.get(i + 1));
            ++i;
        }
        if (recursive) {
            int i2 = 0;
            while (i2 < items.length) {
                IMenuManager mm;
                IContributionItem ci = items[i2];
                if (ci instanceof IMenuManager && !(ci instanceof DoNotSortMenuManager) && (mm = (IMenuManager)ci).isVisible()) {
                    SortingMenuManager.sortMenuItems(mm, recursive);
                }
                ++i2;
            }
        }
    }

    private static List getGroupMarkerPositions(IContributionItem[] items) {
        if (items.length == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Integer> result = new LinkedList<Integer>();
        if (items[0].isGroupMarker()) {
            result.add(new Integer(0));
        }
        int i = 1;
        while (i < items.length - 1) {
            if (items[i].isGroupMarker()) {
                result.add(new Integer(i));
            }
            ++i;
        }
        if (items[items.length - 1].isGroupMarker()) {
            result.add(new Integer(items.length - 1));
        } else {
            result.add(new Integer(items.length));
        }
        return result;
    }

    private static void sortMenuItems(IMenuManager menu, IContributionItem[] items, int startSeparatorIndex, int endSeparatorIndex) {
        Object groupName = null;
        TreeMap<String, IContributionItem> sortedItems = new TreeMap<String, IContributionItem>();
        int i = startSeparatorIndex + 1;
        while (i < endSeparatorIndex) {
            String id = items[i].getId();
            if (id == null) {
                id = LARGEST_ID;
            }
            while (sortedItems.containsKey(id)) {
                id = id + LARGEST_ID;
            }
            sortedItems.put(id, items[i]);
            menu.remove(items[i]);
            ++i;
        }
        Iterator it = sortedItems.keySet().iterator();
        while (it.hasNext()) {
            IContributionItem nextItem = (IContributionItem)sortedItems.get(it.next());
            menu.appendToGroup(items[startSeparatorIndex].getId(), nextItem);
        }
    }

    private static String getItemId(IContributionItem[] items, int index) {
        if (index == -1) {
            return "<start>";
        }
        if (index == items.length) {
            return "<end>";
        }
        return items[index].getId();
    }
}

