/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.StringSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;

final class PropertySupportMap {
    private final Map mySupportsMap = new HashMap();
    static final StringSupport DEFAULT_SUPPORT = new StringSupport();

    PropertySupportMap() {
    }

    public IPropertySupport getSupport(String id) {
        Object entry = this.mySupportsMap.get(id);
        if (entry == null) {
            ChromePlugin.warn("PropertySupport for '" + id + "' not found, using default.", null);
            return DEFAULT_SUPPORT;
        }
        if (entry instanceof IPropertySupportProxy) {
            IPropertySupport rv = this.extractSupport((IPropertySupportProxy)entry);
            if (rv != null) {
                this.mySupportsMap.put(id, rv);
            }
            return rv;
        }
        return (IPropertySupport)entry;
    }

    public void addSupport(String id, IPropertySupportProxy entry) {
        this.mySupportsMap.put(id, entry);
    }

    public String[] getAllKeys() {
        Set keys = this.mySupportsMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    private IPropertySupport extractSupport(IPropertySupportProxy proxy) {
        try {
            return proxy.instantiate();
        }
        catch (CoreException ex) {
            ChromePlugin.warn("Couldn't instantiate PropertySupport using proxy:" + proxy, ex);
            return null;
        }
    }

    public static interface IPropertySupportProxy {
        public IPropertySupport instantiate() throws CoreException;
    }
}

