/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.StringMarshaler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class PropertySupport
implements IExecutableExtension,
IPropertySupport {
    private static final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private static final WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
    private static final IPropertyMarshaler defaultPropertyMarshaler = new StringMarshaler();
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private IPropertyMarshaler propertyMarshaler = defaultPropertyMarshaler;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String marshaler = config.getAttribute("marshaler");
        if (marshaler != null) {
            this.propertyMarshaler = ChromePlugin.getInstance().getPropertyMarshaler(marshaler);
        }
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = this.createLabelProvider();
        }
        return this.labelProvider;
    }

    public ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    public IPropertyMarshaler getPropertyMarshaler() {
        return this.propertyMarshaler;
    }

    protected ILabelProvider createLabelProvider() {
        return workbenchLabelProvider;
    }

    protected ITreeContentProvider createContentProvider() {
        return workbenchContentProvider;
    }

    public abstract CellEditor createPropertyEditor(Composite var1);
}

