/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.StringMarshaler;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;

final class PropertyMarshalerMap {
    static final StringMarshaler DEFAULT_MARSHALER = new StringMarshaler();
    private final HashMap myMarshalers = new HashMap();

    PropertyMarshalerMap() {
    }

    public void addMarshaler(Object type, IPropertyMarshalerProxy entry) {
        this.myMarshalers.put(type, entry);
    }

    public IPropertyMarshaler getMarshaler(Object type) {
        Object entry = this.myMarshalers.get(type);
        if (entry instanceof IPropertyMarshaler) {
            return (IPropertyMarshaler)entry;
        }
        if (entry instanceof IPropertyMarshalerProxy) {
            entry = this.instantiateMarshaler((IPropertyMarshalerProxy)entry);
        }
        if (entry == null) {
            ChromePlugin.warn("PropertyMarshaler for '" + type + "' not found, using default (String).", null);
            return DEFAULT_MARSHALER;
        }
        this.myMarshalers.put(type, entry);
        return (IPropertyMarshaler)entry;
    }

    private IPropertyMarshaler instantiateMarshaler(IPropertyMarshalerProxy proxy) {
        try {
            return proxy.instantiate();
        }
        catch (CoreException ex) {
            ChromePlugin.warn(ex.getMessage(), ex);
            return null;
        }
    }

    public static interface IPropertyMarshalerProxy {
        public IPropertyMarshaler instantiate() throws CoreException;
    }
}

