/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.internal.Messages;
import com.tssap.selena.ui.internal.PropertySupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class IntegerSupport
extends PropertySupport {
    protected ILabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new IntegerCellEditor(parent);
    }

    private static class IntegerCellEditor
    extends TextCellEditor {
        public IntegerCellEditor(Composite parent) {
            super(parent);
        }

        protected Object doGetValue() {
            Object text = super.doGetValue();
            try {
                Integer.parseInt((String)text);
            }
            catch (NumberFormatException fe) {
                return null;
            }
            return text;
        }

        protected boolean isCorrect(Object value) {
            try {
                Integer.parseInt(value.toString());
            }
            catch (NumberFormatException format) {
                this.setErrorMessage(Messages.getString("IntegerSupport.Ilegal_number_format_1"));
                return false;
            }
            return super.isCorrect(value);
        }

        protected void doSetValue(Object value) {
            if (value == null) {
                value = "";
            } else if (!(value instanceof String)) {
                value = value.toString();
            }
            super.doSetValue(value);
        }
    }
}

