/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.internal.Messages;
import com.tssap.selena.ui.internal.PropertySupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class FloatSupport
extends PropertySupport {
    protected ILabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new FloatCellEditor(parent);
    }

    private static class FloatCellEditor
    extends TextCellEditor {
        public FloatCellEditor(Composite parent) {
            super(parent);
            this.setValidator(new ICellEditorValidator(this){
                private final /* synthetic */ FloatCellEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public String isValid(Object value) {
                    if (value instanceof String) {
                        try {
                            Float.parseFloat((String)value);
                            return null;
                        }
                        catch (NumberFormatException ex) {
                            return Messages.getString("FloatSupport.Ilegal_number_format_1");
                        }
                    }
                    if (value instanceof Float) {
                        return null;
                    }
                    return Messages.getString("FloatSupport.Non-integer_value__2") + value + " (" + value.getClass() + ")";
                }
            });
        }

        protected Object doGetValue() {
            Object text = super.doGetValue();
            if (text instanceof String) {
                return new Float((String)text);
            }
            throw new IllegalStateException("unexpected value " + text.getClass());
        }

        protected void doSetValue(Object value) {
            if (value instanceof Float) {
                super.doSetValue((Object)value.toString());
            } else {
                System.err.println("unexpected value " + this.text.getClass());
            }
        }
    }
}

