/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.internal.Messages;
import com.tssap.selena.ui.internal.PropertySupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class DateSupport
extends PropertySupport {
    protected ILabelProvider createLabelProvider() {
        return new DateLabelProvider();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new DateCellEditor(parent);
    }

    private static class DateCellEditor
    extends TextCellEditor {
        public DateCellEditor(Composite parent) {
            super(parent);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    if (value instanceof String) {
                        if (((String)value).length() > 0) {
                            try {
                                DateFormat.getDateInstance(3).parse((String)value);
                                return null;
                            }
                            catch (ParseException ex) {
                                return Messages.getString("DateSupport.Ilegal_date_format___1") + ex.getMessage();
                            }
                        }
                        return null;
                    }
                    if (value instanceof Date) {
                        return null;
                    }
                    if (value == null) {
                        return null;
                    }
                    return Messages.getString("DateSupport.Non-date_value__2") + value + " (" + value.getClass() + ")";
                }
            });
        }

        protected Object doGetValue() {
            Object text = super.doGetValue();
            if (text instanceof String) {
                try {
                    if (((String)text).length() > 0) {
                        return DateFormat.getDateInstance(3).parse((String)text);
                    }
                    return null;
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    throw new IllegalStateException("unexpected exception " + ex.getMessage() + " while parsing " + text.getClass());
                }
            }
            if (text != null) {
                throw new IllegalStateException("unexpected value " + text.getClass());
            }
            return null;
        }

        protected void doSetValue(Object value) {
            if (value instanceof Date) {
                super.doSetValue((Object)DateFormat.getDateInstance(3).format((Date)value));
            } else if (value != null) {
                System.err.println("unexpected value " + value);
            }
        }
    }

    private static class DateLabelProvider
    extends LabelProvider {
        private DateLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Date) {
                return DateFormat.getDateInstance(3).format((Date)element);
            }
            return super.getText(element);
        }
    }
}

