/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.ContextMenuContributor;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;

class ContextMenuContributorRegistry {
    public static final String EXTENSION = "contextMenuContributors";
    public static final String NAME_ATTRIBUTE = "contributor";
    public static final String CLASS_ATTRIBUTE = "class";
    private Collection myObjects;
    private IExtensionPoint myExtensionPoint;

    public ContextMenuContributorRegistry(IPluginDescriptor descriptor) {
        this.myExtensionPoint = descriptor.getExtensionPoint(EXTENSION);
    }

    public ContextMenuContributor[] getContributors() {
        this.loadObjects();
        return this.myObjects.toArray(new ContextMenuContributor[this.myObjects.size()]);
    }

    private void loadObjects() {
        if (this.myObjects == null) {
            this.myObjects = new ArrayList();
            if (this.myExtensionPoint != null) {
                IConfigurationElement[] confElements = this.myExtensionPoint.getConfigurationElements();
                int cei = 0;
                while (cei < confElements.length) {
                    this.loadObject(confElements[cei]);
                    ++cei;
                }
            }
        }
    }

    private void loadObject(IConfigurationElement confElement) {
        if (confElement.getName().equals(NAME_ATTRIBUTE)) {
            Object object = null;
            try {
                object = confElement.createExecutableExtension(CLASS_ATTRIBUTE);
                if (object instanceof ContextMenuContributor) {
                    this.myObjects.add(object);
                }
            }
            catch (CoreException ce) {
                ChromePlugin.error("Unable to create instance of [" + confElement.getAttribute(CLASS_ATTRIBUTE) + "]", ce);
            }
        }
    }
}

