/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.internal.PropertySupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class ConfigurableSupport
extends PropertySupport {
    private static final String ATTR_VALUES = "values";
    private static final String ATTR_DEFAULT_VALUE = "defaultValue";
    private static final String ATTR_DISPLAY_VALUES = "displayValues";
    private Map myValues2DisplayValues;
    private String[] myValues = new String[0];
    private String[] myDisplayValues;
    private String myDefaultValue;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        String values = config.getAttribute(ATTR_VALUES);
        String displayValues = config.getAttribute(ATTR_DISPLAY_VALUES);
        ArrayList<String> collectDisplayValues = null;
        if (displayValues != null) {
            this.myValues2DisplayValues = new HashMap();
            collectDisplayValues = new ArrayList<String>();
        }
        if (values != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(values, ",");
            StringTokenizer dispValues = new StringTokenizer(displayValues != null ? displayValues : "", ",");
            while (st.hasMoreTokens()) {
                String value = st.nextToken().trim();
                list.add(value);
                String valueToDisplay = value;
                if (dispValues.hasMoreTokens() && (valueToDisplay = dispValues.nextToken().trim()).length() > 0) {
                    this.myValues2DisplayValues.put(value, valueToDisplay);
                }
                if (collectDisplayValues == null) continue;
                collectDisplayValues.add(valueToDisplay);
            }
            if (!list.isEmpty()) {
                this.myValues = new String[list.size()];
                list.toArray(this.myValues);
            }
            if (collectDisplayValues != null && !collectDisplayValues.isEmpty()) {
                this.myDisplayValues = new String[collectDisplayValues.size()];
                collectDisplayValues.toArray(this.myDisplayValues);
            }
        }
        this.myDefaultValue = config.getAttribute(ATTR_DEFAULT_VALUE);
    }

    public String[] getValues() {
        return this.myValues;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    protected String getDisplayValue(String value) {
        if (this.myValues2DisplayValues != null && this.myValues2DisplayValues.containsKey(value)) {
            return (String)this.myValues2DisplayValues.get(value);
        }
        return value;
    }

    protected String[] getDisplayValues() {
        if (this.myDisplayValues == null) {
            return this.getValues();
        }
        return this.myDisplayValues;
    }
}

