/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.IPropertySupportWithParams;
import com.tssap.selena.ui.ImageBundle;
import com.tssap.selena.ui.internal.ContextMenuContributor;
import com.tssap.selena.ui.internal.ContextMenuContributorRegistry;
import com.tssap.selena.ui.internal.PropertyMarshalerMap;
import com.tssap.selena.ui.internal.PropertySupportMap;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ChromePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.tssap.selena.ui";
    private static final String PT_IMAGES = "images";
    private static final String PT_SUPPORTS = "propertySupports";
    private static final String PT_MARSHALERS = "propertyMarshalers";
    private static final String NODE_SUPPORT = "support";
    private static final String NODE_MARSHALLER = "marshaler";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CLASS = "class";
    private static final String NODE_ALIAS = "alias";
    private static final String ATTR_ALIAS_TYPE = "type";
    private static final String ATTR_ALIAS_TARGET = "support";
    private static boolean debug;
    private static ChromePlugin plugin;
    private static ImageBundle imageBundle;
    private static PropertySupportMap propertySupports;
    private static PropertyMarshalerMap propertyMarshalers;
    private ContextMenuContributorRegistry myContextMenuContributorRegistry;

    public static ChromePlugin getInstance() {
        return plugin;
    }

    public static IStatus log(IStatus status) {
        plugin.getLog().log(status);
        return status;
    }

    public static IStatus info(String message) {
        return ChromePlugin.info(message, null);
    }

    public static IStatus info(String message, Throwable exception) {
        return ChromePlugin.log((IStatus)new Status(1, PLUGIN_ID, 1, message, exception));
    }

    public static void warn(String message, Throwable ex) {
        ChromePlugin.log((IStatus)new Status(2, PLUGIN_ID, 0, message, ex));
    }

    public static IStatus error(String message) {
        return ChromePlugin.error(message, null);
    }

    public static IStatus error(String message, Throwable exception) {
        return ChromePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, exception));
    }

    public static IStatus debug(String message) {
        return ChromePlugin.debug(message, null);
    }

    public static IStatus debug(String message, Throwable exception) {
        if (!debug) {
            return null;
        }
        return ChromePlugin.log((IStatus)new Status(1, PLUGIN_ID, 1, message, exception));
    }

    public ChromePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        debug = this.isDebugging();
        plugin = this;
    }

    public IPropertySupport getPropertySupport(String id) {
        return propertySupports.getSupport(id);
    }

    public IPropertySupport getPropertySupport(String id, Object[] params) {
        IPropertySupport ps = this.getPropertySupport(id);
        if (ps instanceof IPropertySupportWithParams) {
            return ((IPropertySupportWithParams)ps).cloneWith(params);
        }
        return ps;
    }

    public IPropertyMarshaler getPropertyMarshaler(Object id) {
        return propertyMarshalers.getMarshaler(id);
    }

    public String[] getAvailableTypes() {
        return propertySupports.getAllKeys();
    }

    public void startup() throws CoreException {
        IPluginDescriptor descriptor = this.getDescriptor();
        IExtensionPoint pt = descriptor.getExtensionPoint(PT_MARSHALERS);
        if (pt != null) {
            this.hookPropertyMarshalers(pt);
        }
        if ((pt = descriptor.getExtensionPoint(PT_SUPPORTS)) != null) {
            this.hookPropertySupports(pt);
        }
        ChromePlugin.loadContextMenuContributors();
    }

    public ImageBundle getImageBundle() {
        if (imageBundle == null) {
            imageBundle = this.createImageBundle();
            Platform.getPlugin((String)"com.tssap.selena.model.ui.navigator");
        }
        return imageBundle;
    }

    protected ImageBundle createImageBundle() {
        ImageBundle bundle = new ImageBundle();
        IExtensionPoint pt = this.getDescriptor().getExtensionPoint(PT_IMAGES);
        if (pt != null) {
            IExtension[] exts = pt.getExtensions();
            int i = 0;
            while (i < exts.length) {
                this.addImageDescriptors(bundle, exts[i]);
                ++i;
            }
        }
        return bundle;
    }

    protected void addImageDescriptors(ImageBundle bundle, IExtension ext) {
        IPluginDescriptor descriptor = ext.getDeclaringPluginDescriptor();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        URL base = descriptor.getInstallURL();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String name = element.getName();
            if (name.equals("image")) {
                String id = element.getAttribute("id");
                String ref = element.getAttribute("url");
                if (id == null || ref == null) {
                    ChromePlugin.error("cannot create ImageDescriptor: " + element);
                } else {
                    bundle.addImageDescriptor(id, this.createImageDescriptor(base, ref));
                }
            }
            ++i;
        }
    }

    private ImageDescriptor createImageDescriptor(URL base, String ref) {
        try {
            URL url = new URL(base, ref);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            ChromePlugin.error("cannot create ImageDescriptor", e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private void hookPropertySupports(IExtensionPoint pt) throws CoreException {
        propertySupports = new PropertySupportMap();
        IConfigurationElement[] exts = pt.getConfigurationElements();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement ext = exts[i];
            String name = ext.getName();
            if ("support".equals(name)) {
                this.addPropertySupport(ext);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < exts.length) {
            if (NODE_ALIAS.equals(exts[i2].getName())) {
                this.addPropertyAlias(exts[i2]);
            }
            ++i2;
        }
    }

    private void hookPropertyMarshalers(IExtensionPoint pt) throws CoreException {
        propertyMarshalers = new PropertyMarshalerMap();
        IConfigurationElement[] exts = pt.getConfigurationElements();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement ext = exts[i];
            String name = ext.getName();
            if (NODE_MARSHALLER.equals(name)) {
                this.addPropertyMarshaler(ext);
            }
            ++i;
        }
    }

    private void addPropertySupport(IConfigurationElement el) {
        String id = el.getAttribute("type");
        String cls = el.getAttribute(ATTR_CLASS);
        if (id == null || cls == null) {
            ChromePlugin.error("invalid property support (missing markup) " + el);
            return;
        }
        this.addPropertySupport(id, new PropertySupportProxy(el));
    }

    private void addPropertySupport(String id, PropertySupportMap.IPropertySupportProxy entry) {
        ChromePlugin.debug("[Chrome] PropertySupportProxy " + entry + " registered for type " + id);
        propertySupports.addSupport(id, entry);
    }

    private void addPropertyAlias(IConfigurationElement el) {
        String id = el.getAttribute("type");
        if (id == null) {
            ChromePlugin.error("[Chrome] invalid property alias: " + el.getName());
            return;
        }
        String target = el.getAttribute("support");
        if (target != null) {
            this.addPropertySupport(id, new AliasSupportProxy(target));
        }
    }

    private void addPropertyMarshaler(IConfigurationElement el) throws CoreException {
        String id = el.getAttribute("type");
        if (id == null) {
            ChromePlugin.error("invalid property marshaler (missing id) " + el);
            return;
        }
        this.addPropertyMarshaler(id, new PropertyMarshalerProxy(el));
    }

    private void addPropertyMarshaler(Object id, PropertyMarshalerMap.IPropertyMarshalerProxy entry) {
        ChromePlugin.debug("[Chrome] PropertyMarshallerProxy " + entry + " registered for type " + id);
        propertyMarshalers.addMarshaler(id, entry);
    }

    public ContextMenuContributor[] getContextMenuContributors() {
        if (this.myContextMenuContributorRegistry == null) {
            this.myContextMenuContributorRegistry = new ContextMenuContributorRegistry(ChromePlugin.getInstance().getDescriptor());
        }
        return this.myContextMenuContributorRegistry.getContributors();
    }

    private static void loadContextMenuContributors() {
        ChromePlugin.getInstance().getContextMenuContributors();
    }

    private static final class PropertyMarshalerProxy
    implements PropertyMarshalerMap.IPropertyMarshalerProxy {
        private final IConfigurationElement myMarshalerElement;

        public PropertyMarshalerProxy(IConfigurationElement element) {
            if (element == null) {
                throw new NullPointerException();
            }
            this.myMarshalerElement = element;
        }

        public IPropertyMarshaler instantiate() throws CoreException {
            return (IPropertyMarshaler)this.myMarshalerElement.createExecutableExtension(ChromePlugin.ATTR_CLASS);
        }

        public String toString() {
            return this.myMarshalerElement.toString();
        }
    }

    private static final class AliasSupportProxy
    implements PropertySupportMap.IPropertySupportProxy {
        private final String myTarget;

        public AliasSupportProxy(String target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.myTarget = target;
        }

        public IPropertySupport instantiate() throws CoreException {
            return ChromePlugin.getInstance().getPropertySupport(this.myTarget);
        }
    }

    private static final class PropertySupportProxy
    implements PropertySupportMap.IPropertySupportProxy {
        private final IConfigurationElement myConfigElement;

        public PropertySupportProxy(IConfigurationElement element) {
            if (element == null) {
                throw new NullPointerException();
            }
            this.myConfigElement = element;
        }

        public IPropertySupport instantiate() throws CoreException {
            return (IPropertySupport)this.myConfigElement.createExecutableExtension(ChromePlugin.ATTR_CLASS);
        }

        public String toString() {
            return this.myConfigElement.toString();
        }
    }
}

