/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class Chrome {
    private Chrome() {
    }

    public static boolean showProgress(WorkspaceModifyOperation op) {
        try {
            new ProgressMonitorDialog(Chrome.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Chrome.openException(e.getTargetException());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static void openEditor(IWorkbenchPage page, IEditorInput input, String editorId) {
        try {
            IEditorPart editor = Chrome.getEditorPart(page, input);
            if (editor == null) {
                page.openEditor(input, editorId, true);
            } else {
                page.activate((IWorkbenchPart)editor);
            }
        }
        catch (PartInitException e) {
            Chrome.openException(e);
        }
    }

    public static IEditorDescriptor findEditor(String editorId) {
        return Chrome.getWorkbench().getEditorRegistry().findEditor(editorId);
    }

    private static IEditorPart getEditorPart(IWorkbenchPage page, IEditorInput input) {
        IEditorPart[] editors = page.getEditors();
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i];
            if (input.equals(editor.getEditorInput())) {
                return editor;
            }
            ++i;
        }
        return null;
    }

    public static void openException(Throwable e) {
        Chrome.openException(e, e.getMessage(), Messages.getString("Chrome.Operation_Failed"));
    }

    public static void openException(Throwable e, String message) {
        Chrome.openException(e, message, Messages.getString("Chrome.Operation_Failed"));
    }

    public static void openException(Throwable e, String message, String title) {
        if (message == null) {
            message = e.toString();
        }
        ChromePlugin.error(message, e);
        if (e instanceof CoreException) {
            ErrorDialog.openError((Shell)Chrome.getShell(), (String)title, (String)message, (IStatus)((CoreException)e).getStatus());
        } else {
            MessageDialog.openError((Shell)Chrome.getShell(), (String)title, (String)e.toString());
        }
    }

    public static boolean executeOperation(WorkspaceModifyOperation op) {
        try {
            new ProgressMonitorDialog(Chrome.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Chrome.openException(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell() {
        return Chrome.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    private static double getVerticalDialogUnitSize(Control control) {
        double d;
        GC gc = new GC((Drawable)control);
        try {
            int height = gc.getFontMetrics().getHeight();
            d = (double)height * 0.125;
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return d;
    }

    private static double getHorizontalDialogUnitSize(Control control) {
        double d;
        GC gc = new GC((Drawable)control);
        try {
            int averageWidth = gc.getFontMetrics().getAverageCharWidth();
            d = (double)averageWidth * 0.25;
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return d;
    }

    public static int convertHeightInCharsToPixels(int chars, Control control) {
        return Chrome.convertVerticalDLUsToPixels(chars * 8, control);
    }

    public static int convertHorizontalDLUsToPixels(int dlus, Control control) {
        return (int)Math.round((double)dlus * Chrome.getHorizontalDialogUnitSize(control));
    }

    public static int convertVerticalDLUsToPixels(int dlus, Control control) {
        return (int)Math.round((double)dlus * Chrome.getVerticalDialogUnitSize(control));
    }

    public static int convertWidthInCharsToPixels(int chars, Control control) {
        return Chrome.convertHorizontalDLUsToPixels(chars * 4, control);
    }

    public static int getButtonWidthHint(Button button) {
        int widthHint = Chrome.convertHorizontalDLUsToPixels(61, (Control)button);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getButtonHeigthHint(Button button) {
        return Chrome.convertVerticalDLUsToPixels(14, (Control)button);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).heightHint = Chrome.getButtonHeigthHint(button);
            ((GridData)gd).widthHint = Chrome.getButtonWidthHint(button);
        }
    }

    public static GridData createButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.widthHint = Chrome.getButtonWidthHint(button);
        data.heightHint = Chrome.getButtonHeigthHint(button);
        return data;
    }
}

