/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui.internal;

import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AutoHiddenSubMenu
extends MenuManager {
    public AutoHiddenSubMenu() {
    }

    public AutoHiddenSubMenu(String text) {
        super(text);
    }

    public AutoHiddenSubMenu(String text, String id) {
        super(text, id);
    }

    public void update(boolean force) {
        super.update(force);
        if (this.hasNoMenuItemsExceptSeparators(this.getMenu())) {
            this.getMenu().setVisible(false);
            this.setVisible(false);
            this.dispose();
        }
    }

    private boolean hasNoMenuItemsExceptSeparators(Menu menu) {
        MenuItem[] mi = menu.getItems();
        int i = 0;
        while (i < mi.length) {
            if ((mi[i].getStyle() & 2) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void sortGroups(boolean recursive) {
        AutoHiddenSubMenu.sortGroups((IMenuManager)this, recursive);
    }

    private static void sortGroups(IMenuManager menu, boolean recursive) {
        IContributionItem[] items = menu.getItems();
        TreeSet groupsPositions = AutoHiddenSubMenu.getGroupsPositions(items);
        AutoHiddenSubMenu.sortGroups(menu, items, groupsPositions);
        if (recursive) {
            int i = 0;
            while (i < items.length) {
                IMenuManager mm;
                IContributionItem ci = items[i];
                if (ci instanceof IMenuManager && (mm = (IMenuManager)ci).isVisible()) {
                    AutoHiddenSubMenu.sortGroups(mm, recursive);
                }
                ++i;
            }
        }
    }

    private static void sortGroups(IMenuManager menu, IContributionItem[] items, TreeSet groupsPositions) {
        if (groupsPositions.size() > 1) {
            int i = 0;
            while (i < items.length) {
                menu.remove(items[i]);
                ++i;
            }
            IContributionItem[] sortedItems = new IContributionItem[items.length];
            Iterator itr = groupsPositions.iterator();
            int j = 0;
            while (itr.hasNext()) {
                SortableGroupPosition position = (SortableGroupPosition)itr.next();
                int startPosition = position.getStartPosition();
                int endPosition = position.getEndPosition();
                int p = startPosition;
                while (p <= endPosition) {
                    sortedItems[j] = items[p];
                    ++j;
                    ++p;
                }
            }
            int i2 = 0;
            while (i2 < sortedItems.length) {
                menu.add(sortedItems[i2]);
                ++i2;
            }
        }
    }

    private static TreeSet getGroupsPositions(IContributionItem[] items) {
        TreeSet<SortableGroupPosition> treeSet = new TreeSet<SortableGroupPosition>();
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            int startPosition = i;
            if (item.isSeparator()) {
                String id = item.getId();
                int endPosition = items.length - 1;
                int j = i + 1;
                while (j < items.length) {
                    item = items[j];
                    if (item.isSeparator()) {
                        endPosition = j - 1;
                        break;
                    }
                    ++j;
                }
                i = endPosition;
                SortableGroupPosition group = new SortableGroupPosition(id, startPosition, endPosition);
                treeSet.add(group);
            }
            ++i;
        }
        return treeSet;
    }

    private static class SortableGroupPosition
    implements Comparable {
        private String myID;
        private int myStartPosition;
        private int myEndPosition;

        SortableGroupPosition(String id, int startPosition, int endPosition) {
            this.myID = id;
            this.myStartPosition = startPosition;
            this.myEndPosition = endPosition;
        }

        public int compareTo(Object o) {
            String id = ((SortableGroupPosition)o).myID;
            return this.myID.compareTo(id);
        }

        public String getID() {
            return this.myID;
        }

        public int getStartPosition() {
            return this.myStartPosition;
        }

        public int getEndPosition() {
            return this.myEndPosition;
        }
    }
}

