/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class ImageBundle {
    private HashMap images = new HashMap(10);
    private HashMap descriptors = new HashMap(10);

    public ImageBundle() {
        this(Display.getCurrent());
    }

    public ImageBundle(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                ImageBundle.this.dispose();
            }
        });
    }

    private void dispose() {
        Iterator it = this.images.values().iterator();
        while (it.hasNext()) {
            ((Image)it.next()).dispose();
        }
        this.images = null;
        this.descriptors = null;
    }

    public void addImage(String key, Image image) {
        this.images.put(key, image);
    }

    public void addImageDescriptor(String key, ImageDescriptor descriptor) {
        this.descriptors.put(key, descriptor);
    }

    public String[] getAllKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.size()]);
    }

    public Image getImage(String key) {
        ImageDescriptor descriptor;
        Image image = (Image)this.images.get(key);
        if (image == null && (descriptor = (ImageDescriptor)this.descriptors.get(key)) != null) {
            image = descriptor.createImage();
            this.images.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return (ImageDescriptor)this.descriptors.get(key);
    }
}

