/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class CompositeProgressMonitor
extends ProgressMonitorWrapper {
    private int myCurrentMontiorCount;
    private int myMonitorLength;
    private int myMonitorCount;
    private String myName;

    public CompositeProgressMonitor(IProgressMonitor monitor, String name, int monitorCount, int monitorLength) {
        super(monitor);
        this.myMonitorLength = monitorLength;
        this.myMonitorCount = monitorCount;
        this.myName = name;
    }

    public void beginTask(String name, int totalWork) {
        if (this.myCurrentMontiorCount == 0) {
            super.beginTask(this.myName, this.myMonitorCount * this.myMonitorLength);
        } else {
            super.subTask(this.getCompositeName(name));
        }
    }

    public void subTask(String name) {
        super.subTask(this.getCompositeName(name));
    }

    public void done() {
        ++this.myCurrentMontiorCount;
        if (this.myCurrentMontiorCount == this.myMonitorCount) {
            super.done();
        }
    }

    public void worked(int work) {
        super.worked(work);
    }

    private String getCompositeName(String name) {
        return this.myName + " (" + (this.myCurrentMontiorCount + 1) + "/" + this.myMonitorCount + ") : " + name;
    }
}

