/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.tracing.patterns;

import com.sap.engine.library.bytecode.misc.PackageSystemPropertiesTree;
import com.sap.engine.library.bytecode.misc.StringUtils;
import com.sap.engine.library.bytecode.tracing.Tracer;
import com.sap.engine.library.bytecode.tracing.TracingPattern;

public final class PropertiesTreeTracingPattern
extends TracingPattern {
    private final PackageSystemPropertiesTree tree;
    private final String module;

    public PropertiesTreeTracingPattern(PackageSystemPropertiesTree tree, String module) {
        this.tree = tree;
        this.module = module;
    }

    public boolean matchesMethod(Class c, int classId, String methodName, String methodDescriptor, int methodId) {
        String identifier = Tracer.getClassName(classId).replace('.', '/') + '.' + Tracer.getMethodName(classId, methodId) + Tracer.getMethodDescriptor(classId, methodId);
        String s = (String)this.tree.get(identifier, "module");
        if (s == null) {
            return false;
        }
        String[] modules = StringUtils.splitAndTrim(s, ';');
        int i = 0;
        while (i < modules.length) {
            if (this.module.equals(modules[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

