/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.tracing.patterns;

import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.misc.StringUtils;
import com.sap.engine.library.bytecode.tracing.TracingPattern;

public final class ListedTracingPattern
extends TracingPattern {
    private String configurationString;
    private String[] matchedClassNames;
    private String[] matchedMethodNames;
    private String[] matchedMethodDescriptors;
    private boolean[] isPackage;
    private int nMatchedMethods;

    public ListedTracingPattern(String configurationString) {
        if (configurationString == null) {
            throw new IllegalArgumentException("configurationString must not be null.");
        }
        this.configurationString = configurationString;
        String[] items = StringUtils.split(configurationString, ',');
        this.nMatchedMethods = items.length;
        this.matchedClassNames = new String[this.nMatchedMethods];
        this.matchedMethodNames = new String[this.nMatchedMethods];
        this.matchedMethodDescriptors = new String[this.nMatchedMethods];
        this.isPackage = new boolean[this.nMatchedMethods];
        int i = 0;
        while (i < items.length) {
            String item = items[i].trim();
            String[] a = StringUtils.split(item, '#');
            if (a.length > 2) {
                throw new IllegalArgumentException("Illegal configurationString, \"" + configurationString + "\", more than one '#' in item \"" + item + "\".");
            }
            this.matchedClassNames[i] = a[0];
            if (a.length > 1) {
                String signature = a[1];
                int indexOfOpeningBracket = signature.indexOf(40);
                if (indexOfOpeningBracket == -1) {
                    this.matchedMethodNames[i] = signature;
                } else {
                    this.matchedMethodNames[i] = signature.substring(0, indexOfOpeningBracket);
                    this.matchedMethodDescriptors[i] = signature.substring(indexOfOpeningBracket);
                    MethodInfo.checkMethodParameters(this.matchedMethodDescriptors[i]);
                }
            } else if (a[0].endsWith(".")) {
                this.isPackage[i] = true;
            }
            ++i;
        }
    }

    public boolean matchesMethod(Class c, int classId, String methodName, String methodDescriptor, int methodId) {
        int i = 0;
        while (i < this.nMatchedMethods) {
            if (this.isPackage[i] ? c.getName().startsWith(this.matchedClassNames[i]) : !(!this.matchedClassNames[i].equals(c.getName()) || this.matchedMethodNames[i] != null && !this.matchedMethodNames[i].equals(methodName) || this.matchedMethodDescriptors[i] != null && !this.matchedMethodDescriptors[i].equals(methodDescriptor))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getConfigurationString() {
        return this.configurationString;
    }

    public String toString0() {
        return this.configurationString;
    }
}

