/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.tracing.handlers;

import com.sap.engine.library.bytecode.tracing.Tracer;
import com.sap.engine.library.bytecode.tracing.TracingHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PrintStreamTracingHandler
extends TracingHandler {
    private PrintStream out = System.out;

    public PrintStreamTracingHandler() {
    }

    public PrintStreamTracingHandler(PrintStream out) {
        this.out = out == null ? System.out : out;
    }

    protected void propertyChanged(String name, String oldValue, String value) {
        if (name.equals("file")) {
            try {
                this.out = new PrintStream(new FileOutputStream(value));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void methodStart(int classId, int methodId, Object thisPointer, Object[] arguments) {
        this.out.println("METHOD START " + Tracer.getClassName(classId) + '.' + Tracer.getMethodName(classId, methodId) + Tracer.getMethodDescriptor(classId, methodId));
    }

    public void methodEnd(int classId, int methodId, Object returnedValue, Throwable thrown) {
        this.out.println("METHOD END " + Tracer.getClassName(classId) + '.' + Tracer.getMethodName(classId, methodId) + Tracer.getMethodDescriptor(classId, methodId));
    }

    private static String objectToString(Object x) {
        if (x == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('(').append(x.getClass().getName()).append('@').append(System.identityHashCode(x)).append(") ");
        return buffer.toString();
    }
}

