/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.tracing;

import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.tracing.TracingHandler;
import com.sap.engine.library.bytecode.tracing.TracingPattern;

public final class TracingPlugin {
    static final TracingPlugin[] TRACING_PLUGIN_ARRAY_0 = new TracingPlugin[0];
    private static int uniqueIdCounter = 0;
    private static final Object uniqueIdCounterLock = new Object();
    private final Object lock = new Object();
    private int index = -1;
    private TracingPattern pattern;
    private TracingHandler[] handlers = new TracingHandler[10];
    private int nHandlers;
    private String name;
    private final int uniqueId;
    private boolean isEnabled = true;

    public TracingPlugin() {
        this(null);
    }

    public TracingPlugin(String name) {
        this.pattern = TracingPattern.ALL;
        Object object = uniqueIdCounterLock;
        synchronized (object) {
            this.uniqueId = uniqueIdCounter++;
        }
        this.name = name == null ? Integer.toString(this.uniqueId) : name;
    }

    public void setPattern(TracingPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIsInUse();
            this.pattern = pattern;
        }
    }

    public void addHandler(TracingHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        if (this.handlers.length == this.nHandlers) {
            this.handlers = TracingPlugin.resize(this.handlers);
        }
        Object object = this.lock;
        synchronized (object) {
            this.handlers[this.nHandlers++] = handler;
        }
    }

    public void removeHandler(TracingHandler h) {
        if (h == null) {
            return;
        }
        int i = 0;
        while (i < this.nHandlers) {
            if (h == this.handlers[i]) {
                this.removeHandler0(i);
                return;
            }
            ++i;
        }
    }

    private void removeHandler0(int index) {
        Object object = this.lock;
        synchronized (object) {
            --this.nHandlers;
            System.arraycopy(this.handlers, index + 1, this.handlers, index, this.nHandlers - index);
        }
    }

    public TracingPattern getPattern() {
        return this.pattern;
    }

    TracingHandler[] getHandlersWithoutCopying() {
        return this.handlers;
    }

    public TracingHandler[] getHandlers() {
        TracingHandler[] r;
        Object object = this.lock;
        synchronized (object) {
            r = new TracingHandler[this.nHandlers];
            System.arraycopy(this.handlers, 0, r, 0, this.nHandlers);
        }
        return r;
    }

    void plug() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < this.nHandlers) {
                this.handlers[i].plugWith(this);
                ++i;
            }
        }
    }

    void unplug() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < this.nHandlers) {
                this.handlers[i].unplugWith(this);
                ++i;
            }
        }
    }

    private void checkIsInUse() {
        if (this.index != -1) {
            throw new IllegalArgumentException(ResourceManager.get(176, this));
        }
    }

    public boolean isInUse() {
        return this.index != -1;
    }

    void setUnused() {
        this.index = -1;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name != null ? "PLUGIN[" + this.name + "]" : "PLUGIN[UNNAMED]";
    }

    void methodStart(int classId, int methodId, Object thisPointer, Object[] arguments) throws Exception {
        if (this.isEnabled) {
            int i = 0;
            while (i < this.nHandlers) {
                this.handlers[i].methodStart(classId, methodId, thisPointer, arguments);
                ++i;
            }
        }
    }

    void methodEnd(int classId, int methodId, Object returnValue, Throwable thrown) throws Exception {
        if (this.isEnabled) {
            int i = 0;
            while (i < this.nHandlers) {
                this.handlers[i].methodEnd(classId, methodId, returnValue, thrown);
                ++i;
            }
        }
    }

    void beforeMonitorEnter(int classId, int methodId, Object lock) throws Exception {
        if (this.isEnabled) {
            int i = 0;
            while (i < this.nHandlers) {
                this.handlers[i].beforeMonitorEnter(classId, methodId, lock);
                ++i;
            }
        }
    }

    void afterMonitorEnter(int classId, int methodId, Object lock) throws Exception {
        if (this.isEnabled) {
            int i = 0;
            while (i < this.nHandlers) {
                this.handlers[i].afterMonitorEnter(classId, methodId, lock);
                ++i;
            }
        }
    }

    void afterMonitorExit(int classId, int methodId, Object lock) throws Exception {
        if (this.isEnabled) {
            int i = 0;
            while (i < this.nHandlers) {
                this.handlers[i].afterMonitorExit(classId, methodId, lock);
                ++i;
            }
        }
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public static TracingHandler[] resize(TracingHandler[] a) {
        TracingHandler[] r = new TracingHandler[2 * a.length];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public void setEnabled(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.isEnabled = b;
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

