/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.tracing;

import com.sap.engine.library.bytecode.misc.ArrayUtils;
import com.sap.engine.library.bytecode.misc.StringUtils;
import com.sap.engine.library.bytecode.tracing.TracingPlugin;
import java.util.Properties;

public abstract class TracingHandler {
    private String[] p = new String[16];
    private int np;
    private Object pLock = new Object();

    protected TracingHandler() {
    }

    public void methodStart(int classId, int methodId, Object thisPointer, Object[] arguments) throws Exception {
    }

    public void methodEnd(int classId, int methodId, Object returnedValue, Throwable thrown) throws Exception {
    }

    public void beforeMonitorEnter(int classId, int methodId, Object lock) throws Exception {
    }

    public void afterMonitorEnter(int classId, int methodId, Object lock) throws Exception {
    }

    public void afterMonitorExit(int classId, int methodId, Object lock) throws Exception {
    }

    public void plugWith(TracingPlugin plugin) throws Exception {
    }

    public void unplugWith(TracingPlugin plugin) throws Exception {
    }

    public final void setProperty(String name, String value) throws Exception {
        boolean bChanged;
        String oldValue;
        block12: {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            Object object = this.pLock;
            synchronized (object) {
                int i = 0;
                while (i < this.np) {
                    if (this.p[i].equals(name)) {
                        oldValue = this.p[i + 1];
                        if (value == null) {
                            this.p[i] = this.p[this.np - 2];
                            this.p[i + 1] = this.p[this.np - 1];
                            this.np -= 2;
                            bChanged = true;
                        } else {
                            this.p[i + 1] = value;
                            bChanged = !oldValue.equals(value);
                        }
                        break block12;
                    }
                    i += 2;
                }
                oldValue = null;
                if (value == null) {
                    bChanged = false;
                } else {
                    if (this.np == this.p.length) {
                        this.p = ArrayUtils.resize(this.p);
                    }
                    this.p[this.np] = name;
                    this.p[this.np + 1] = value;
                    this.np += 2;
                    bChanged = true;
                }
            }
        }
        if (bChanged) {
            this.propertyChanged(name, oldValue, value);
        }
    }

    public final String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String r = null;
        Object object = this.pLock;
        synchronized (object) {
            int i = 0;
            while (i < this.np) {
                if (name.equals(this.p[i])) {
                    r = this.p[i + 1];
                    break;
                }
                i += 2;
            }
        }
        return r;
    }

    public final String[] getPropertyNames() {
        String[] r;
        Object object = this.pLock;
        synchronized (object) {
            r = new String[this.np / 2];
            int i = 0;
            while (i < this.np) {
                r[i / 2] = this.p[i];
                i += 2;
            }
        }
        return r;
    }

    public final Properties getProperties() {
        Properties r = new Properties();
        Object object = this.pLock;
        synchronized (object) {
            int i = 0;
            while (i < this.np) {
                r.setProperty(this.p[i], this.p[i + 1]);
                i += 2;
            }
        }
        return r;
    }

    protected void propertyChanged(String name, String oldValue, String value) throws Exception {
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(StringUtils.fqNameToShortName(this.getClass()));
        if (this.np > 0) {
            Object object = this.pLock;
            synchronized (object) {
                buffer.append('[');
                int i = 0;
                while (i < this.np) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    buffer.append(this.p[i]).append('=').append(this.p[i + 1]);
                    i += 2;
                }
                buffer.append(']');
            }
        }
        return buffer.toString();
    }
}

