/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.tracing;

import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.misc.Debug;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.tracing.TracingPattern;
import com.sap.engine.library.bytecode.tracing.TracingPlugin;
import com.sap.engine.library.bytecode.tracing.event.HandlerExceptionEvent;
import com.sap.engine.library.bytecode.tracing.event.HandlerExceptionListener;
import com.sap.engine.library.bytecode.tracing.event.PluginEvent;
import com.sap.engine.library.bytecode.tracing.event.PluginListener;
import com.sap.engine.library.bytecode.tracing.event.WarningEvent;
import com.sap.engine.library.bytecode.tracing.event.WarningListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;

public final class Tracer {
    private static final Object lock = new Object();
    private static final int INITIAL_MAX_CLASSES = 256;
    private static final int INITIAL_MAX_METHODS = 1024;
    private static int nClasses = 0;
    private static Class[] classes = new Class[256];
    private static String[] classNames = new String[256];
    private static String[][] methodNames = new String[256][];
    private static String[][] methodDescriptors = new String[256][];
    private static int[] classIdToMethodStartIndex = new int[256];
    private static int nMethods = 0;
    private static int[] methodIdToPluginsBitSet = new int[1024];
    private static int nPlugins = 0;
    private static TracingPlugin[] plugins = new TracingPlugin[32];
    public static final Object[] OBJECT_ARRAY_0 = new Object[0];
    private static final int N_INTEGERS = 1024;
    private static final Integer[] INTEGERS = new Integer[1024];
    private static final ArrayList warningListeners = new ArrayList();
    private static final ArrayList pluginListeners = new ArrayList();
    private static final ArrayList handlerExceptionListeners = new ArrayList();

    private Tracer() {
    }

    public static int register(Class c, String className, String[] methodNames0, String[] methodDescriptors0) {
        if (Debug.DEBUG_TRACING) {
            if (c == null) {
                throw new IllegalArgumentException();
            }
            if (className == null) {
                throw new IllegalArgumentException();
            }
            if (methodNames0 == null) {
                throw new IllegalArgumentException();
            }
            if (methodDescriptors0 == null) {
                throw new IllegalArgumentException();
            }
            if (!c.getName().equals(className)) {
                throw new IllegalArgumentException();
            }
            if (methodNames0.length != methodDescriptors0.length) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < methodNames0.length) {
                if (methodNames0[i] == null) {
                    throw new IllegalArgumentException("methodNames0[" + i + "]");
                }
                if (methodDescriptors0[i] == null) {
                    throw new IllegalArgumentException("methodDescriptors0[" + i + "]");
                }
                MethodInfo.checkMethodDescriptor(methodDescriptors0[i]);
                ++i;
            }
        }
        Object object = lock;
        synchronized (object) {
            int classId = nClasses;
            if (classId >= classes.length) {
                Class[] classesOld = classes;
                classes = new Class[nClasses * 2];
                System.arraycopy(classesOld, 0, classes, 0, nClasses);
                String[] classNamesOld = classNames;
                classNames = new String[nClasses * 2];
                System.arraycopy(classNamesOld, 0, classNames, 0, nClasses);
                String[][] methodNamesOld = methodNames;
                methodNames = new String[nClasses * 2][];
                System.arraycopy(methodNamesOld, 0, methodNames, 0, nClasses);
                String[][] methodDescriptorsOld = methodDescriptors;
                methodDescriptors = new String[nClasses * 2][];
                System.arraycopy(methodDescriptorsOld, 0, methodDescriptors, 0, nClasses);
                int[] classIdToMethodStartIndexOld = classIdToMethodStartIndex;
                classIdToMethodStartIndex = new int[nClasses * 2];
                System.arraycopy(classIdToMethodStartIndexOld, 0, classIdToMethodStartIndex, 0, nClasses);
            }
            Tracer.classes[classId] = c;
            Tracer.classNames[classId] = className;
            Tracer.methodNames[classId] = methodNames0;
            Tracer.methodDescriptors[classId] = methodDescriptors0;
            Tracer.classIdToMethodStartIndex[Tracer.nClasses] = nMethods;
            if (nMethods + methodNames0.length >= methodIdToPluginsBitSet.length) {
                int[] methodIdToPluginsBitSetOld = methodIdToPluginsBitSet;
                methodIdToPluginsBitSet = new int[nMethods * 2];
                System.arraycopy(methodIdToPluginsBitSetOld, 0, methodIdToPluginsBitSet, 0, methodIdToPluginsBitSetOld.length);
            }
            int pluginId = 0;
            while (pluginId < nPlugins) {
                TracingPattern pattern = plugins[pluginId].getPattern();
                int mask = 1 << pluginId;
                int nMethods = methodNames0.length;
                int methodIdToPluginsBitSetOffset = classIdToMethodStartIndex[classId];
                int methodId = 0;
                while (methodId < nMethods) {
                    if (pattern.matchesMethod(c, classId, methodNames0[methodId], methodDescriptors0[methodId], methodId)) {
                        int n = methodIdToPluginsBitSetOffset + methodId;
                        methodIdToPluginsBitSet[n] = methodIdToPluginsBitSet[n] | mask;
                    }
                    ++methodId;
                }
                ++pluginId;
            }
            ++nClasses;
            nMethods += methodNames.length;
            int n = classId;
            return n;
        }
    }

    public static void methodStart(int classId, int methodId, Object thisPointer, Object[] arguments) {
        if (Debug.DEBUG_TRACING) {
            Tracer.checkClassIdAndMethodId(classId, methodId);
        }
        TracingPlugin[] a = plugins;
        int bits = methodIdToPluginsBitSet[classIdToMethodStartIndex[classId] + methodId];
        int i = 0;
        while (bits != 0) {
            if ((bits & 1) == 1 && a[i] != null) {
                try {
                    a[i].methodStart(classId, methodId, thisPointer, arguments);
                }
                catch (Exception e) {
                    Tracer.fireHandlerExceptionEvent(new HandlerExceptionEvent("When methodStart was invoked on " + a[i], e));
                }
            }
            bits >>= 1;
            ++i;
        }
    }

    public static void methodEnd(int classId, int methodId, Object returnedValue, Throwable thrown) {
        if (Debug.DEBUG_TRACING) {
            Tracer.checkClassIdAndMethodId(classId, methodId);
        }
        TracingPlugin[] a = plugins;
        int bits = methodIdToPluginsBitSet[classIdToMethodStartIndex[classId] + methodId];
        int i = 0;
        while (bits != 0) {
            if ((bits & 1) == 1 && a[i] != null) {
                try {
                    a[i].methodEnd(classId, methodId, returnedValue, thrown);
                }
                catch (Exception e) {
                    Tracer.fireHandlerExceptionEvent(new HandlerExceptionEvent("When methodStart was invoked on " + plugins[i], e));
                }
            }
            bits >>= 1;
            ++i;
        }
    }

    public static void addPlugin(TracingPlugin plugin) {
        Object object = lock;
        synchronized (object) {
            if (nPlugins >= 32) {
                throw new IllegalArgumentException(ResourceManager.get(174));
            }
            if (plugin.isInUse()) {
                throw new IllegalArgumentException(ResourceManager.get(175, plugin));
            }
            if (plugin == null) {
                throw new IllegalArgumentException(ResourceManager.get(69, "plugin"));
            }
            try {
                plugin.plug();
            }
            catch (Exception e) {
                Tracer.fireHandlerExceptionEvent(new HandlerExceptionEvent("When plug() was invoked on " + plugin, e));
                try {
                    plugin.unplug();
                }
                catch (Exception e1) {
                    Tracer.fireHandlerExceptionEvent(new HandlerExceptionEvent("When unplug() was invoked on " + plugin, e1));
                }
            }
            int pluginId = nPlugins;
            int mask = 1 << pluginId;
            TracingPattern pattern = plugin.getPattern();
            int i = 0;
            while (i < nClasses) {
                Class c = classes[i];
                if (c != null) {
                    String[] names = methodNames[i];
                    String[] descriptors = methodDescriptors[i];
                    int nMethods = names.length;
                    int classIdToMethodStartIndexI = classIdToMethodStartIndex[i];
                    int j = 0;
                    while (j < nMethods) {
                        if (pattern.matchesMethod(c, i, names[j], descriptors[j], j)) {
                            int n = classIdToMethodStartIndexI + j;
                            methodIdToPluginsBitSet[n] = methodIdToPluginsBitSet[n] | mask;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Tracer.plugins[pluginId] = plugin;
            plugin.setIndex(++nPlugins);
            Tracer.firePluginAdded(plugin);
        }
    }

    public static void removePlugin(TracingPlugin plugin) {
        Object object = lock;
        synchronized (object) {
            if (Debug.DEBUG_TRACING && plugin == null) {
                throw new IllegalArgumentException(ResourceManager.get(69, "plugin"));
            }
            if (!plugin.isInUse()) {
                throw new IllegalArgumentException(ResourceManager.get(177, plugin));
            }
            TracingPlugin[] a = (TracingPlugin[])plugins.clone();
            int na = nPlugins;
            int pluginId = -1;
            int i = 0;
            while (i < na) {
                if (plugin == a[i]) {
                    pluginId = i;
                    break;
                }
                ++i;
            }
            if (pluginId == -1) {
                throw new IllegalArgumentException("Could not find " + plugin + " in the list of active plugins.");
            }
            a[na - 1].setIndex(pluginId);
            int mask = 1 << pluginId;
            int lastBitMask = 1 << na - 1;
            int i2 = 0;
            while (i2 < nMethods) {
                boolean lastBit;
                int bits = methodIdToPluginsBitSet[i2];
                boolean bl = lastBit = (bits & lastBitMask) != 0;
                bits = lastBit ? (bits |= mask) : (bits &= ~mask);
                Tracer.methodIdToPluginsBitSet[i2] = bits & ~lastBitMask;
                ++i2;
            }
            a[pluginId] = a[na - 1];
            a[na - 1] = null;
            plugins = a;
            nPlugins = --na;
            plugin.setUnused();
            Tracer.firePluginRemoved(plugin);
            try {
                plugin.unplug();
            }
            catch (Exception e) {
                Tracer.fireHandlerExceptionEvent(new HandlerExceptionEvent("When unplug() was invoked on " + plugin, e));
            }
        }
    }

    public static void removeAllPlugins() {
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < nMethods) {
                Tracer.methodIdToPluginsBitSet[i] = 0;
                ++i;
            }
            TracingPlugin[] a = plugins;
            int na = nPlugins;
            int i2 = 0;
            while (i2 < na) {
                if (a[i2] != null) {
                    try {
                        a[i2].unplug();
                    }
                    catch (Exception e) {
                        Tracer.fireHandlerExceptionEvent(new HandlerExceptionEvent("When unplug() was invoked on " + a[i2], e));
                    }
                }
                a[i2].setUnused();
                Tracer.firePluginRemoved(a[i2]);
                ++i2;
            }
            nPlugins = 0;
            Arrays.fill(plugins, null);
        }
    }

    public static int getNClasses() {
        return nClasses;
    }

    public static Class getClass(int classId) {
        return classes[classId];
    }

    public static String getClassName(int classId) {
        return classNames[classId];
    }

    public static int getMethodCount(int classId) {
        return methodNames[classId].length;
    }

    public static String getMethodName(int classId, int methodId) {
        return methodNames[classId][methodId];
    }

    public static String getMethodDescriptor(int classId, int methodId) {
        return methodDescriptors[classId][methodId];
    }

    public static int releaseClassesLoadedBy(ClassLoader loader) {
        int r = 0;
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < nClasses) {
                if (classes[i] != null && classes[i].getClassLoader() == loader) {
                    ++r;
                    Tracer.classes[i] = null;
                }
                ++i;
            }
        }
        return r;
    }

    public static TracingPlugin[] getPlugins() {
        Object object = lock;
        synchronized (object) {
            TracingPlugin[] r = new TracingPlugin[nPlugins];
            System.arraycopy(plugins, 0, r, 0, nPlugins);
            TracingPlugin[] tracingPluginArray = r;
            return tracingPluginArray;
        }
    }

    public static int getAssociations(int classId, int methodId) {
        if (Debug.DEBUG_TRACING) {
            if (classId < 0) {
                throw new IllegalArgumentException();
            }
            if (classId >= nClasses) {
                throw new IllegalArgumentException();
            }
            if (methodId < 0) {
                throw new IllegalArgumentException();
            }
            if (methodId >= classIdToMethodStartIndex[classId] + methodNames[classId].length) {
                throw new IllegalArgumentException();
            }
        }
        return methodIdToPluginsBitSet[classIdToMethodStartIndex[classId] + methodId];
    }

    public static void addWarningListener(WarningListener listener) {
        Object object = lock;
        synchronized (object) {
            warningListeners.add(listener);
        }
    }

    public static void removeWarningListener(WarningListener listener) {
        Object object = lock;
        synchronized (object) {
            ((AbstractCollection)warningListeners).remove(listener);
        }
    }

    public static void fireWarningEvent(WarningEvent event) {
        Object object = lock;
        synchronized (object) {
            int nWarningListeners = warningListeners.size();
            int i = 0;
            while (i < nWarningListeners) {
                ((WarningListener)warningListeners.get(i)).warningIssued(event);
                ++i;
            }
        }
    }

    public static void addPluginListener(PluginListener listener) {
        Object object = lock;
        synchronized (object) {
            pluginListeners.add(listener);
        }
    }

    public static void removePluginListener(PluginListener listener) {
        Object object = lock;
        synchronized (object) {
            ((AbstractCollection)pluginListeners).remove(listener);
        }
    }

    public static void addHandlerExceptionListener(HandlerExceptionListener listener) {
        Object object = lock;
        synchronized (object) {
            handlerExceptionListeners.add(listener);
        }
    }

    public static void removeHandlerExceptionListener(HandlerExceptionListener listener) {
        Object object = lock;
        synchronized (object) {
            ((AbstractCollection)handlerExceptionListeners).remove(listener);
        }
    }

    private static void firePluginAdded(TracingPlugin plugin) {
        int nPluginListeners = pluginListeners.size();
        if (nPluginListeners > 0) {
            PluginEvent event = new PluginEvent(plugin);
            int i = 0;
            while (i < nPluginListeners) {
                ((PluginListener)pluginListeners.get(i)).pluginAdded(event);
                ++i;
            }
        }
    }

    private static void firePluginRemoved(TracingPlugin plugin) {
        int nPluginListeners = pluginListeners.size();
        if (nPluginListeners > 0) {
            PluginEvent event = new PluginEvent(plugin);
            int i = 0;
            while (i < nPluginListeners) {
                ((PluginListener)pluginListeners.get(i)).pluginRemoved(event);
                ++i;
            }
        }
    }

    private static void fireHandlerExceptionEvent(HandlerExceptionEvent event) {
        Object object = lock;
        synchronized (object) {
            int nHandlerExceptionListeners = handlerExceptionListeners.size();
            int i = 0;
            while (i < nHandlerExceptionListeners) {
                ((HandlerExceptionListener)handlerExceptionListeners.get(i)).exceptionThrown(event);
                ++i;
            }
        }
    }

    public static Object wrap(int x) {
        if (x >= 0 && x < 1024) {
            if (INTEGERS[x] == null) {
                Tracer.INTEGERS[x] = new Integer(x);
            }
            return INTEGERS[x];
        }
        return new Integer(x);
    }

    public static Object wrap(long x) {
        return new Long(x);
    }

    public static Object wrap(float x) {
        return new Float(x);
    }

    public static Object wrap(double x) {
        return new Double(x);
    }

    private static void checkClassIdAndMethodId(int classId, int methodId) {
        if (classId < 0) {
            throw new IllegalArgumentException();
        }
        if (classId > nClasses) {
            throw new IllegalArgumentException();
        }
        if (methodId < 0) {
            throw new IllegalArgumentException();
        }
        int nMethods = methodNames[classId].length;
        if (methodId >= nMethods) {
            throw new IllegalArgumentException();
        }
    }

    public static int getGloballyUniqueMethodId(int classId, int methodId) {
        return classIdToMethodStartIndex[classId] + methodId;
    }
}

