/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.modifier;

import com.sap.engine.library.bytecode.modifier.CFModifier;
import com.sap.engine.library.bytecode.tracing.Tracer;
import com.sap.engine.library.bytecode.tracing.TracingHandler;
import com.sap.engine.library.bytecode.tracing.TracingPlugin;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;

public final class ModifyingClassLoader
extends ClassLoader {
    private String[] classNamePrefixes;
    private byte[] buffer = new byte[2048];
    private CFModifier modifier = new CFModifier();
    private Map cache = new Hashtable();
    static /* synthetic */ Class class$com$sap$engine$library$bytecode$modifier$ModifyingClassLoader;

    public ModifyingClassLoader(String[] classNamePrefixes, ClassLoader parent) {
        super(parent);
        this.classNamePrefixes = classNamePrefixes;
    }

    public ModifyingClassLoader(String[] classNamePrefixes) {
        super(null);
        this.classNamePrefixes = classNamePrefixes;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class cachedClass = (Class)this.cache.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        boolean shouldModify = false;
        int i = 0;
        while (i < this.classNamePrefixes.length) {
            if (name.startsWith(this.classNamePrefixes[i])) {
                shouldModify = true;
                break;
            }
            ++i;
        }
        if (!shouldModify) {
            ClassLoader parent = this.getParent();
            if (parent == null) {
                parent = Thread.currentThread().getContextClassLoader();
            }
            return parent.loadClass(name);
        }
        try {
            int k;
            ClassLoader parent = this.getParent();
            String resourceName = name.replace('.', '/') + ".class";
            InputStream in = parent == null ? ClassLoader.getSystemResourceAsStream(resourceName) : parent.getResourceAsStream(resourceName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((k = in.read(this.buffer)) != -1) {
                out.write(this.buffer, 0, k);
            }
            in.close();
            byte[] data = out.toByteArray();
            data = this.modifier.modify(data);
            Class<?> r = this.defineClass(name, data, 0, data.length);
            this.cache.put(name, r);
            return r;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private static void test() {
        System.out.println("Hell, oh, world!");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Invoking normally:");
        ModifyingClassLoader.test();
        System.out.println();
        System.out.println("Invoking through a class loaded by ModifyingClassLoader");
        String name = (class$com$sap$engine$library$bytecode$modifier$ModifyingClassLoader == null ? (class$com$sap$engine$library$bytecode$modifier$ModifyingClassLoader = ModifyingClassLoader.class$("com.sap.engine.library.bytecode.modifier.ModifyingClassLoader")) : class$com$sap$engine$library$bytecode$modifier$ModifyingClassLoader).getName();
        ModifyingClassLoader loader = new ModifyingClassLoader(new String[]{name});
        Class<?> c = loader.loadClass(name);
        Method method = c.getDeclaredMethod("test", null);
        ((AccessibleObject)method).setAccessible(true);
        TracingPlugin plugin = new TracingPlugin();
        plugin.addHandler(new TracingHandler(){

            public void methodStart(int classId, int methodId, Object thisPointer, Object[] arguments) {
                System.out.println("Method start event received.");
            }

            public void methodEnd(int classId, int methodId, Object returnedValue, Throwable thrown) {
                System.out.println("Method end event received.");
            }
        });
        Tracer.addPlugin(plugin);
        method.invoke(null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

