/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.modifier;

import com.sap.engine.library.bytecode.misc.PackageSystemPropertiesTree;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.misc.StringUtils;
import com.sap.engine.library.bytecode.modifier.CFModifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class ModifierTask
extends Task {
    private File conf;
    private String inputFile;
    private String outputFile;
    private int verbosity = 2;
    private boolean failonerror = true;
    private boolean check = true;

    public void setConf(File conf) {
        this.conf = conf;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 0;
    }

    public void setVerbosity(int verbosity) {
        if (verbosity < 0 || verbosity > 2) {
            throw new IllegalArgumentException();
        }
        this.verbosity = verbosity;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void execute() throws BuildException {
        Properties p;
        if (this.inputFile == null) {
            throw new BuildException("Attribute \"inputFile\" is required for this task.");
        }
        if (this.outputFile == null) {
            throw new BuildException("Attribute \"outputFile\" is required for this task.");
        }
        if (this.conf == null) {
            throw new BuildException("Attribute \"conf\" is required for this task.");
        }
        if (this.verbosity > 0) {
            System.out.println("Loading bytecode modifier configuration from " + this.conf);
        }
        try {
            p = new Properties();
            FileInputStream in = new FileInputStream(this.conf);
            p.load(in);
            in.close();
        }
        catch (IOException e) {
            if (this.failonerror) {
                throw new BuildException(ResourceManager.get(33, this.conf), (Throwable)e);
            }
            return;
        }
        long time = System.currentTimeMillis();
        CFModifier modifier = new CFModifier();
        modifier.setVerbosity(this.verbosity);
        modifier.setFailOnError(false);
        modifier.setCheck(false);
        String[] inputFiles = StringUtils.splitAndTrim(this.inputFile, ';');
        String[] outputFiles = StringUtils.splitAndTrim(this.outputFile, ';');
        if (inputFiles.length != outputFiles.length) {
            if (this.failonerror) {
                throw new BuildException(ResourceManager.get(37, inputFiles.length, outputFiles.length));
            }
            if (inputFiles.length > outputFiles.length) {
                String[] oldInputFiles = inputFiles;
                inputFiles = new String[outputFiles.length];
                System.arraycopy(oldInputFiles, 0, inputFiles, 0, outputFiles.length);
            } else {
                String[] oldOutputFiles = outputFiles;
                outputFiles = new String[inputFiles.length];
                System.arraycopy(oldOutputFiles, 0, outputFiles, 0, inputFiles.length);
            }
        }
        if (this.check) {
            if (this.verbosity > 0) {
                System.out.println("Checking whether all classes and methods mentioned in the configuration file exist...");
            }
            try {
                URL[] inputURLs = new URL[inputFiles.length];
                int i = 0;
                while (i < inputFiles.length) {
                    inputURLs[i] = new File(inputFiles[i]).toURL();
                    if (inputURLs[i].toString().endsWith(".jar")) {
                        inputURLs[i] = new URL("jar:" + inputURLs[i] + "!/");
                    }
                    ++i;
                }
                PackageSystemPropertiesTree tree = new PackageSystemPropertiesTree(p);
                ArrayList list = tree.getErrorsAboutNonExistingEntries(inputURLs);
                int nErrors = list.size();
                if (nErrors != 0) {
                    System.out.println("  Some of the entries described in " + this.conf.getAbsolutePath() + " do not exist in the input files");
                    System.out.println("  List of input files:");
                    int i2 = 0;
                    while (i2 < inputFiles.length) {
                        System.out.println("    " + inputFiles[i2]);
                        ++i2;
                    }
                    System.out.println("  List of errors:");
                    int i3 = 0;
                    while (i3 < nErrors) {
                        System.out.println("    " + list.get(i3));
                        ++i3;
                    }
                    if (this.failonerror) {
                        throw new BuildException("Checking of the bytecode modifier's configuration file failed.");
                    }
                }
            }
            catch (Exception e) {
                if (this.failonerror) {
                    e.printStackTrace();
                    throw new BuildException("", (Throwable)e);
                }
                e.printStackTrace();
            }
            if (this.verbosity > 1) {
                System.out.println("Checking finished.");
            }
        }
        int i = 0;
        while (i < inputFiles.length) {
            try {
                modifier.modify(new File(inputFiles[i]), new File(outputFiles[i]), p);
            }
            catch (IOException e) {
                if (this.failonerror) {
                    throw new BuildException((Throwable)e);
                }
                return;
            }
            ++i;
        }
        time = System.currentTimeMillis() - time;
        if (this.verbosity > 0) {
            System.out.println(ResourceManager.get(39, new Long(time)));
        }
    }
}

