/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.modifier;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.modifier.CFModifierOptions;
import com.sap.engine.library.bytecode.modifier.ClassModificationReusableData;
import com.sap.engine.library.bytecode.modifier.MethodModifier;

final class MethodModifierImpl4
implements MethodModifier {
    private static final String L_MODIFIED_START = "MODIFIED_START";
    private static final String L_MODIFIED_END = "MODIFIED_END";
    private static final String L_MODIFIED_HANDLER = "MODIFIED_HANDLER";
    private static final String L_SKIP_METHOD_THROW = "L_SKIP_METHOD_THROW";
    private static final String L_SKIP_METHOD_RETURN = "L_SKIP_METHOD_RETURN";

    MethodModifierImpl4() {
    }

    public boolean modifyMethod(ClassFile cf, MethodInfo m, int mIndex, ClassModificationReusableData d, CFModifierOptions options) {
        if (!options.modify) {
            return false;
        }
        Instruction[] x = d.x;
        CodeAttribute ca = m.getCodeAttribute();
        boolean isStatic = m.isStatic();
        boolean isConstructor = m.getName().equals("<init>");
        char returnTypeCh = m.getReturnType().charAt(0);
        int maxLocals = ca.getOriginalMaxLocals();
        LocalVariable lvLast1 = d.factory.createLocalVariable(maxLocals + 1);
        Instruction[] instructions = ca.getInstructionsArray();
        int nx = 0;
        x[nx++] = ca.createGetStatic(d.cpfClassId);
        x[nx++] = ca.createLDC(mIndex);
        x[nx++] = isStatic || isConstructor ? ca.createACONST_NULL() : ca.createALOAD(d.lv[0]);
        if (options.args) {
            String[] args = m.getArguments();
            if (args.length == 0) {
                x[nx++] = ca.createGetStatic(d.cpfObjectArray0);
            } else {
                x[nx++] = ca.createLDC(args.length);
                x[nx++] = ca.createANEWARRAY(d.cpcObject);
                int lvCounter = isStatic ? 0 : 1;
                int i = 0;
                while (i < args.length) {
                    x[nx++] = ca.createDUP();
                    x[nx++] = ca.createLDC(i);
                    switch (args[i].charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            x[nx++] = ca.createILOAD(d.factory.createLocalVariable(lvCounter));
                            x[nx++] = ca.createInvokeStatic(d.cpmWrapI);
                            ++lvCounter;
                            break;
                        }
                        case 'F': {
                            x[nx++] = ca.createFLOAD(d.factory.createLocalVariable(lvCounter));
                            x[nx++] = ca.createInvokeStatic(d.cpmWrapF);
                            ++lvCounter;
                            break;
                        }
                        case 'J': {
                            x[nx++] = ca.createLLOAD(d.factory.createLocalVariable(lvCounter));
                            x[nx++] = ca.createInvokeStatic(d.cpmWrapJ);
                            lvCounter += 2;
                            break;
                        }
                        case 'D': {
                            x[nx++] = ca.createDLOAD(d.factory.createLocalVariable(lvCounter));
                            x[nx++] = ca.createInvokeStatic(d.cpmWrapD);
                            lvCounter += 2;
                            break;
                        }
                        case 'L': 
                        case '[': {
                            x[nx++] = ca.createALOAD(d.factory.createLocalVariable(lvCounter));
                            ++lvCounter;
                            break;
                        }
                        default: {
                            throw new CFException(41, args[i]);
                        }
                    }
                    x[nx++] = ca.createAASTORE();
                    ++i;
                }
            }
        } else {
            x[nx++] = ca.createACONST_NULL();
        }
        x[nx++] = ca.createInvokeStatic(d.cpmMethodStart);
        int lineNumber = instructions[0].getLineNumber();
        int i = 0;
        while (i < nx) {
            x[i].setLineNumber(lineNumber);
            ++i;
        }
        ca.insert(x, 0, nx, 0);
        LocalVariable lvCaught = d.lv[1];
        nx = 0;
        x[nx++] = ca.createASTORE(lvCaught);
        x[0].addLabel(L_MODIFIED_HANDLER);
        x[nx++] = ca.createGetStatic(d.cpfClassId);
        x[nx++] = ca.createLDC(mIndex);
        x[nx++] = ca.createACONST_NULL();
        x[nx++] = ca.createALOAD(lvCaught);
        x[nx++] = ca.createInvokeStatic(d.cpmMethodEnd);
        x[nx++] = ca.createALOAD(lvCaught).addLabel(L_SKIP_METHOD_THROW);
        x[nx++] = ca.createATHROW();
        ca.createLocalVariableTableAttribute().addEntry(L_MODIFIED_HANDLER, L_SKIP_METHOD_THROW, cf.createCPInfoUtf8("t$throwable"), cf.createCPInfoUtf8("Ljava/lang/Throwable;"), lvCaught);
        instructions[0].addLabel(L_MODIFIED_START);
        instructions[instructions.length - 1].addLabel(L_MODIFIED_END);
        ca.addExceptionHandler(L_MODIFIED_START, L_MODIFIED_HANDLER, false, L_MODIFIED_HANDLER, cf.createCPInfoClass("java/lang/Throwable"));
        lineNumber = instructions[instructions.length - 1].getLineNumber();
        int i2 = 0;
        while (i2 < nx) {
            x[i2].setLineNumber(lineNumber);
            ++i2;
        }
        ca.insertAfter(x, 0, nx, instructions[instructions.length - 1]);
        int returnSectionsCounter = 0;
        int i3 = 0;
        while (i3 < instructions.length) {
            if (instructions[i3].isReturn()) {
                CPInfo wrapper;
                ++returnSectionsCounter;
                String skipLabel = L_SKIP_METHOD_RETURN + i3;
                nx = 0;
                switch (returnTypeCh) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        x[nx++] = ca.createDUP();
                        wrapper = d.cpmWrapI;
                        break;
                    }
                    case 'F': {
                        x[nx++] = ca.createDUP();
                        wrapper = d.cpmWrapF;
                        break;
                    }
                    case 'J': {
                        x[nx++] = ca.createDUP2();
                        wrapper = d.cpmWrapJ;
                        break;
                    }
                    case 'D': {
                        x[nx++] = ca.createDUP2();
                        wrapper = d.cpmWrapD;
                        break;
                    }
                    case 'L': 
                    case '[': {
                        x[nx++] = ca.createDUP();
                        wrapper = null;
                        break;
                    }
                    case 'V': {
                        x[nx++] = ca.createACONST_NULL();
                        wrapper = null;
                        break;
                    }
                    default: {
                        throw new CFException(42, new Character(returnTypeCh));
                    }
                }
                if (wrapper != null) {
                    x[nx++] = ca.createInvokeStatic(wrapper);
                }
                LocalVariable lvRetured = lvLast1;
                x[nx++] = ca.createASTORE(lvRetured).addLabel("L_RETURN_SECTION_START" + returnSectionsCounter);
                x[nx++] = ca.createGetStatic(d.cpfClassId);
                x[nx++] = ca.createLDC(mIndex);
                x[nx++] = ca.createALOAD(lvRetured);
                x[nx++] = ca.createACONST_NULL();
                x[nx++] = ca.createInvokeStatic(d.cpmMethodEnd).addLabel("L_RETURN_SECTION_END" + returnSectionsCounter);
                ca.createLocalVariableTableAttribute().addEntry("L_RETURN_SECTION_START" + returnSectionsCounter, "L_RETURN_SECTION_END" + returnSectionsCounter, cf.createCPInfoUtf8("t$returned"), cf.createCPInfoUtf8("Ljava/lang/Object;"), lvRetured);
                ca.transferLabels(instructions[i3], x[0]);
                instructions[i3].addLabel(skipLabel);
                lineNumber = instructions[i3].getLineNumber();
                int j = 0;
                while (j < nx) {
                    x[j].setLineNumber(lineNumber);
                    ++j;
                }
                ca.insertBefore(x, 0, nx, instructions[i3]);
            }
            ++i3;
        }
        return true;
    }
}

