/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.modifier;

import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class ClearModifiedFilesTask
extends Task {
    private File basedir;
    private File conf;
    private boolean verbose = true;

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setConf(File conf) {
        this.conf = conf;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        Properties p;
        if (this.basedir == null) {
            throw new BuildException(ResourceManager.get(32, "dir"));
        }
        if (this.conf == null) {
            throw new BuildException(ResourceManager.get(32, "conf"));
        }
        try {
            p = new Properties();
            p.load(new FileInputStream(this.conf));
        }
        catch (IOException e) {
            throw new BuildException(ResourceManager.get(33, this.conf.toString()), (Throwable)e);
        }
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            boolean r;
            File file;
            String name = (String)enumeration.nextElement();
            if (name.endsWith("*")) continue;
            if (name.indexOf(46) != -1) {
                name = name.substring(0, name.indexOf(46));
            }
            if (!(file = new File(this.basedir, name = name + ".class")).exists()) {
                if (!this.verbose) continue;
                System.out.println(ResourceManager.get(35, name));
                continue;
            }
            if (file.isDirectory()) {
                if (!this.verbose) continue;
                System.out.println(ResourceManager.get(36, name));
                continue;
            }
            try {
                r = file.delete();
            }
            catch (SecurityException e) {
                r = false;
            }
            if (!this.verbose) continue;
            if (r) {
                System.out.println(ResourceManager.get(34, name));
                continue;
            }
            System.out.println(ResourceManager.get(40, name));
        }
    }
}

