/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.modifier;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFParser;
import com.sap.engine.library.bytecode.cf.CFSerializer;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.cf.SAPModifiedAttribute;
import com.sap.engine.library.bytecode.misc.PackageSystemPropertiesTree;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.modifier.CFModifierOptions;
import com.sap.engine.library.bytecode.modifier.ClassModificationReusableData;
import com.sap.engine.library.bytecode.modifier.MethodModifier;
import com.sap.engine.library.bytecode.modifier.MethodModifierImpl4;
import com.sap.engine.library.bytecode.modifier.ModificationResult;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class CFModifier {
    public static final String NUMBER_OF_MODIFIED_CLASSES_PROPERTY = "nModifiedClasses";
    public static final String NUMBER_OF_MODIFIED_METHODS_PROPERTY = "nModifiedMethods";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final String PREFIX = "t$";
    protected static final String S_CLASS_ID = "t$classId";
    protected static final String S_TRACER = "com/sap/engine/library/bytecode/tracing/Tracer";
    private static final String S_SERIAL_VERSION_UID = "serialVersionUID";
    private final CFParser parser;
    private final CFSerializer serializer;
    private final ClassModificationReusableData d = new ClassModificationReusableData();
    private final MethodModifier methodModifier = new MethodModifierImpl4();
    private final byte[] buffer = new byte[2048];
    private boolean failOnError = true;
    private boolean check = true;
    private boolean shouldCancel = false;
    private static final int MIN_VERBOSITY = 0;
    private static final int MAX_VERBOSITY = 2;
    private int verbosity = 2;

    public CFModifier() {
        this.d.factory = CFFactory.getThreadLocalInstance();
        this.parser = this.d.factory.createCFParser();
        this.serializer = this.d.factory.createCFSerializer();
        this.d.lv = new LocalVariable[5];
        int i = 0;
        while (i < this.d.lv.length) {
            this.d.lv[i] = this.d.factory.createLocalVariable(i);
            ++i;
        }
        this.d.x = new Instruction[65536];
    }

    public void setVerbosity(int verbosity) {
        if (verbosity < 0) {
            throw new IllegalArgumentException();
        }
        if (verbosity > 2) {
            throw new IllegalArgumentException();
        }
        this.verbosity = verbosity;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public byte[] modify(byte[] bytecode) throws IOException {
        ClassFile cf = this.parser.parse(bytecode, null);
        this.modifyClass(cf, null, null, null, null);
        return this.serializer.serializeToByteArray(cf, null);
    }

    public void modifyClass(ClassFile cf, CFModifierOptions options, String[] methodNamesAndDescriptors, CFModifierOptions[] methodOptions, ModificationResult result) {
        CodeAttribute ca;
        if (this.shouldCancel) {
            this.shouldCancel = false;
            throw new CFException(50);
        }
        if (cf == null) {
            throw new CFException(69, "cf");
        }
        if (methodNamesAndDescriptors != null) {
            int i = 0;
            while (i < methodNamesAndDescriptors.length) {
                if (methodNamesAndDescriptors[i] == null) {
                    throw new CFException(55, new Object[]{"methodNamesAndDescriptors", new Integer(i)});
                }
                ++i;
            }
        }
        if (methodOptions != null) {
            if (methodNamesAndDescriptors == null) {
                throw new CFException(54, new Object[]{"methodOptions", "methodNamesAndDescriptors"});
            }
            if (methodNamesAndDescriptors.length != methodOptions.length) {
                throw new CFException(53, new Object[]{"methodOptions", new Integer(methodOptions.length), "methodNamesAndDescriptors", new Integer(methodNamesAndDescriptors.length)});
            }
        }
        CFModifierOptions cFModifierOptions = options = options == null ? CFModifierOptions.DEFAULT : options;
        if (cf.isInterface()) {
            return;
        }
        if (result != null) {
            ++result.nModifiedClasses;
            this.propertyChangeSupport.firePropertyChange(NUMBER_OF_MODIFIED_CLASSES_PROPERTY, result.nModifiedClasses - 1, result.nModifiedClasses);
        }
        if (cf.getAttribute("COM.SAP.Modified") != null) {
            if (result != null) {
                ++result.nModifiedInAdvanceClasses;
            }
            return;
        }
        if (options.fixSerialVersionUID && cf.getField(S_SERIAL_VERSION_UID) == null && cf.getMethod("<clinit>", "()V") == null) {
            long suid = cf.computeSerialVersionUID();
            FieldInfo fSUID = cf.createField(S_SERIAL_VERSION_UID, "J");
            fSUID.setPrivate(true);
            fSUID.setStatic(true);
            fSUID.setFinal(true);
            fSUID.setConstantValue(cf.createCPInfoLong(suid));
        }
        cf.addAttribute(new SAPModifiedAttribute(1));
        MethodInfo[] methods = cf.getMethodsArray();
        FieldInfo fClassId = cf.createField(S_CLASS_ID, "I");
        fClassId.setPrivate(true);
        fClassId.setTransient(true);
        fClassId.setStatic(true);
        fClassId.createSyntheticAttribute();
        this.d.cpfClassId = fClassId.toCPInfo(cf);
        CPInfo cpcTracer = cf.createCPInfoClass(S_TRACER);
        this.d.cpmMethodStart = cf.createCPInfoMemberRef(10, cpcTracer, "register", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V");
        this.d.cpmMethodStart = cf.createCPInfoMemberRef(10, cpcTracer, "methodStart", "(IILjava/lang/Object;[Ljava/lang/Object;)V");
        this.d.cpmMethodEnd = cf.createCPInfoMemberRef(10, cpcTracer, "methodEnd", "(IILjava/lang/Object;Ljava/lang/Throwable;)V");
        this.d.cpmWrapI = cf.createCPInfoMemberRef(10, cpcTracer, "wrap", "(I)Ljava/lang/Object;");
        this.d.cpmWrapJ = cf.createCPInfoMemberRef(10, cpcTracer, "wrap", "(J)Ljava/lang/Object;");
        this.d.cpmWrapF = cf.createCPInfoMemberRef(10, cpcTracer, "wrap", "(F)Ljava/lang/Object;");
        this.d.cpmWrapD = cf.createCPInfoMemberRef(10, cpcTracer, "wrap", "(D)Ljava/lang/Object;");
        this.d.cpcObject = cf.createCPInfoClass("java/lang/Object");
        this.d.cpmClassForName = cf.createCPInfoMemberRef(10, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        this.d.cpfObjectArray0 = cf.createCPInfoMemberRef(9, cpcTracer, "OBJECT_ARRAY_0", "[Ljava/lang/Object;");
        this.d.cp0 = cf.getCPInfo(0);
        int nMethods = methods.length;
        MethodInfo[] modifiedMethods = new MethodInfo[methods.length];
        int nModifiedMethods = 0;
        int i = 0;
        while (i < nMethods) {
            boolean b;
            boolean mustModify;
            MethodInfo m = methods[i];
            CodeAttribute ca2 = m.getCodeAttribute();
            if (ca2 == null) {
                mustModify = false;
            } else if (methodNamesAndDescriptors == null) {
                mustModify = true;
            } else {
                mustModify = false;
                int j = 0;
                while (j < methodNamesAndDescriptors.length) {
                    if ((m.getName() + m.getDescriptor()).equals(methodNamesAndDescriptors[j])) {
                        mustModify = true;
                        break;
                    }
                    ++j;
                }
            }
            if (mustModify && (b = this.methodModifier.modifyMethod(cf, m, nModifiedMethods, this.d, methodOptions == null || methodOptions[i] == null ? options : methodOptions[i]))) {
                if (result != null) {
                    ++result.nModifiedMethods;
                    this.propertyChangeSupport.firePropertyChange(NUMBER_OF_MODIFIED_METHODS_PROPERTY, result.nModifiedMethods - 1, result.nModifiedMethods);
                }
                modifiedMethods[nModifiedMethods] = methods[i];
                ++nModifiedMethods;
            }
            ++i;
        }
        MethodInfo mClInit = cf.getMethod("<clinit>", "()V");
        Instruction[] x = this.d.x;
        if (mClInit == null) {
            mClInit = cf.createMethod("<clinit>", "()V");
            mClInit.setPublic(true);
            mClInit.setStatic(true);
            ca = mClInit.createCodeAttribute();
            x[0] = ca.createRETURN();
            ca.insert(x, 0, 1, 0);
        } else {
            ca = mClInit.getCodeAttribute();
        }
        String className = cf.getName().replace('/', '.');
        int nx = 0;
        x[nx++] = ca.createLDC(className);
        x[nx++] = ca.createInvokeStatic(this.d.cpmClassForName).addLabel("cfn");
        x[nx++] = ca.createLDC(className);
        x[nx++] = ca.createLDC(nModifiedMethods);
        x[nx++] = ca.createANEWARRAY("java/lang/String");
        int i2 = 0;
        while (i2 < nModifiedMethods) {
            x[nx++] = ca.createDUP();
            x[nx++] = ca.createLDC(i2);
            x[nx++] = ca.createLDC(modifiedMethods[i2].getName());
            x[nx++] = ca.createAASTORE();
            ++i2;
        }
        x[nx++] = ca.createLDC(nModifiedMethods);
        x[nx++] = ca.createANEWARRAY("java/lang/String");
        int i3 = 0;
        while (i3 < nModifiedMethods) {
            x[nx++] = ca.createDUP();
            x[nx++] = ca.createLDC(i3);
            x[nx++] = ca.createLDC(modifiedMethods[i3].getDescriptor());
            x[nx++] = ca.createAASTORE();
            ++i3;
        }
        x[nx++] = ca.createInvokeStatic(S_TRACER, "register", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)I");
        x[nx++] = ca.createPutStatic(this.d.cpfClassId);
        ca.insert(x, 0, nx, 0);
    }

    public ModificationResult modify(File inputDirOrJar, File outputDirOrJar, Properties p) throws IOException {
        if (inputDirOrJar == null) {
            throw new CFException(69, "inputDirOrJar");
        }
        if (!inputDirOrJar.exists()) {
            throw new CFException(47, inputDirOrJar);
        }
        if (outputDirOrJar == null) {
            throw new CFException(69, "outputDirOrJar");
        }
        if (p == null) {
            throw new CFException(69, "p");
        }
        if (this.verbosity > 0) {
            if (inputDirOrJar.equals(outputDirOrJar)) {
                System.out.println(ResourceManager.get(48) + " " + inputDirOrJar);
            } else {
                System.out.println(ResourceManager.get(46) + " " + inputDirOrJar);
                System.out.println(ResourceManager.get(52) + " " + outputDirOrJar);
            }
        }
        boolean inputIsDir = inputDirOrJar.isDirectory();
        boolean outputIsDir = !outputDirOrJar.exists() || outputDirOrJar.isDirectory();
        boolean inputIsJar = !inputIsDir && inputDirOrJar.getName().endsWith(".jar");
        boolean outputIsJar = !outputDirOrJar.exists() || !outputIsDir && outputDirOrJar.getName().endsWith(".jar");
        PackageSystemPropertiesTree tree = new PackageSystemPropertiesTree(p);
        if (this.check) {
            if (this.verbosity > 0) {
                System.out.print(ResourceManager.get(43));
            }
            try {
                tree.checkAllPackageSystemIdentifiersExist(inputIsDir ? inputDirOrJar.toURL() : new URL("jar:" + inputDirOrJar.toURL() + "!/"));
            }
            catch (IOException e) {
                if (this.failOnError) {
                    throw e;
                }
                if (this.verbosity > 0) {
                    e.printStackTrace(System.out);
                } else {
                    System.out.println(e);
                }
            }
            catch (RuntimeException e) {
                if (this.failOnError) {
                    throw e;
                }
                if (this.verbosity > 0) {
                    e.printStackTrace(System.out);
                }
                System.out.println(e);
            }
            if (this.verbosity > 0) {
                System.out.println(ResourceManager.get(44));
            }
        }
        ModificationResult result = new ModificationResult();
        if (inputIsDir && outputIsDir) {
            this.modifyDir(inputDirOrJar, outputDirOrJar, tree, result);
        } else if (inputIsJar && outputIsJar) {
            this.modifyJar(inputDirOrJar, outputDirOrJar, tree, result);
        } else {
            throw new CFException(45);
        }
        return result;
    }

    private void modifyJar(File inputJar, File outputJar, PackageSystemPropertiesTree tree, ModificationResult result) throws IOException {
        ZipEntry entry;
        File tempFile = File.createTempFile("bytecode-modifier", "jar");
        ZipInputStream in = new ZipInputStream(new FileInputStream(inputJar));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));
        while ((entry = in.getNextEntry()) != null) {
            ZipEntry outEntry = new ZipEntry(entry.getName());
            out.putNextEntry(outEntry);
            String entryName = entry.getName();
            boolean shouldCopy = true;
            if (entryName.endsWith(".class")) {
                boolean bModify;
                String packageSystemIdentifier = entryName.substring(0, entryName.length() - ".class".length());
                String sModify = (String)tree.get(packageSystemIdentifier, "modify");
                boolean bl = bModify = sModify != null && sModify.equals("1");
                if (bModify || tree.hasDescendants(packageSystemIdentifier)) {
                    if (this.verbosity > 1) {
                        System.out.println("  " + ResourceManager.get(51) + " " + entryName);
                    }
                    ClassFile cf = this.parser.parse(in, null);
                    this.modifyClass(cf, packageSystemIdentifier, tree, result);
                    this.serializer.serialize(out, cf, null);
                    shouldCopy = false;
                }
            }
            if (!shouldCopy) continue;
            this.copy(in, out);
        }
        out.close();
        in.close();
        FileInputStream in1 = new FileInputStream(tempFile);
        FileOutputStream out1 = new FileOutputStream(outputJar);
        this.copy(in1, out1);
        in1.close();
        out1.close();
        tempFile.delete();
    }

    private void modifyDir(File inputDir, File outputDir, PackageSystemPropertiesTree tree, ModificationResult result) throws IOException {
        this.modifyDir0(inputDir, outputDir, "", tree, result);
    }

    private void modifyDir0(File inputDir, File outputDir, String path, PackageSystemPropertiesTree tree, ModificationResult result) throws IOException {
        boolean bModify;
        String[] children = new File(inputDir, path).list();
        if (children == null || children.length == 0) {
            return;
        }
        String packageSystemIdentifier = path.length() == 0 ? "**" : path + "/**";
        Object sModify = tree.get(packageSystemIdentifier, "modify");
        boolean bl = bModify = sModify != null && sModify.equals("1");
        if (!tree.hasDescendants(packageSystemIdentifier) && !bModify) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            if (path.length() != 0) {
                children[i] = path + '/' + children[i];
            }
            if (children[i].endsWith(".class")) {
                boolean bModifyClass;
                ClassFile cf = this.parser.parse(new File(inputDir, children[i]), null);
                String classPackageSystemIdentifier = children[i].substring(0, children[i].length() - ".class".length());
                Object sModifyClass = tree.get(classPackageSystemIdentifier, "modify");
                boolean bl2 = bModifyClass = sModifyClass != null && sModifyClass.equals("1");
                if (bModifyClass || tree.hasDescendants(classPackageSystemIdentifier)) {
                    if (this.verbosity > 1) {
                        System.out.println("  " + ResourceManager.get(51) + " " + children[i]);
                    }
                    this.modifyClass(cf, classPackageSystemIdentifier, tree, result);
                    File file = new File(outputDir, children[i]);
                    file.getParentFile().mkdirs();
                    this.serializer.serialize(file, cf, null);
                }
            } else if (!children[i].startsWith(".")) {
                this.modifyDir0(inputDir, outputDir, children[i], tree, result);
            }
            ++i;
        }
    }

    private void modifyClass(ClassFile cf, String classPackageSystemIdentifier, PackageSystemPropertiesTree tree, ModificationResult result) {
        String[] methodNamesAndDescriptors = null;
        CFModifierOptions[] methodOptions = null;
        if (tree.hasDescendants(classPackageSystemIdentifier)) {
            MethodInfo[] methods = cf.getMethodsArray();
            methodNamesAndDescriptors = new String[methods.length];
            methodOptions = new CFModifierOptions[methods.length];
            int i = 0;
            while (i < methods.length) {
                methodNamesAndDescriptors[i] = methods[i].getName() + methods[i].getDescriptor();
                String methodPackageSystemIdentifier = classPackageSystemIdentifier + '.' + methodNamesAndDescriptors[i];
                methodOptions[i] = CFModifier.parseOptions(methodPackageSystemIdentifier, tree);
                if (methodOptions[i].modify && this.verbosity > 0) {
                    System.out.println("    " + ResourceManager.get(49) + " " + methodNamesAndDescriptors[i]);
                }
                ++i;
            }
        }
        CFModifierOptions classOptions = CFModifier.parseOptions(classPackageSystemIdentifier, tree);
        this.modifyClass(cf, classOptions, methodNamesAndDescriptors, methodOptions, result);
    }

    private static CFModifierOptions parseOptions(String packageSystemIdentifier, PackageSystemPropertiesTree tree) {
        String sFixSUID;
        boolean bModify;
        CFModifierOptions r = new CFModifierOptions();
        String sModify = (String)tree.get(packageSystemIdentifier, "modify");
        r.modify = bModify = sModify != null && sModify.equals("1");
        String sArgs = (String)tree.get(packageSystemIdentifier, "args");
        if (sArgs != null) {
            boolean bArgs;
            r.args = bArgs = sArgs != null && sArgs.equals("1");
        }
        if ((sFixSUID = (String)tree.get(packageSystemIdentifier, "fix-suid")) != null) {
            boolean bFixSUID;
            r.fixSerialVersionUID = bFixSUID = sFixSUID != null && sFixSUID.equals("1");
        }
        return r;
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int k;
        while ((k = in.read(this.buffer)) != -1) {
            out.write(this.buffer, 0, k);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void cancel() {
        this.shouldCancel = true;
    }

    private static void printUsage() {
        System.out.print(ResourceManager.get(56));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            CFModifier.printUsage();
            return;
        }
        CFModifier modifier = new CFModifier();
        Properties p = new Properties();
        p.load(new FileInputStream(args[0]));
        File inputFile = new File(args[0]);
        File outputFile = new File(args.length < 3 ? args[1] : args[2]);
        modifier.setVerbosity(2);
        modifier.modify(inputFile, outputFile, p);
    }
}

