/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import com.sap.engine.library.bytecode.misc.JobQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;

public class XProperties
extends Properties
implements Cloneable {
    private final transient JobQueue queue;
    private final String[] allowedPropertyNames;
    private transient int nListeners = 0;
    private transient PropertyChangeListener[] listeners;
    private transient String[] listenerInterests;

    public XProperties() {
        this(null, null);
    }

    public XProperties(String[] allowedPropertyNames, JobQueue eventQueue) {
        this.allowedPropertyNames = allowedPropertyNames == null ? null : (String[])allowedPropertyNames.clone();
        this.queue = eventQueue;
    }

    public final Object setProperty(final String propertyName, final String value) {
        String oldValue;
        if (this.allowedPropertyNames != null) {
            boolean found = false;
            int i = 0;
            while (i < this.allowedPropertyNames.length) {
                if (propertyName.equals(this.allowedPropertyNames[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                throw new IllegalArgumentException();
            }
        }
        if (value.equals(oldValue = super.getProperty(propertyName))) {
            return value;
        }
        super.setProperty(propertyName, value);
        if (this.queue == null) {
            this.firePropertyChange(propertyName, oldValue, value);
        } else {
            this.queue.addJob(new Runnable(){

                public void run() {
                    XProperties.this.firePropertyChange(propertyName, oldValue, value);
                }
            });
        }
        return oldValue;
    }

    public final void setIntProperty(String propertyName, int value) {
        this.setProperty(propertyName, Integer.toString(value));
    }

    public final int getIntProperty(String propertyName) {
        return this.getIntProperty(propertyName, 0);
    }

    public final int getIntProperty(String propertyName, int defaultValue) {
        int x;
        String s = this.getProperty(propertyName);
        try {
            x = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            x = defaultValue;
        }
        return x;
    }

    private void firePropertyChange(String propertyName, String oldValue, String newValue) {
        XProperties xProperties = this;
        synchronized (xProperties) {
            PropertyChangeEvent event = null;
            int i = 0;
            while (i < this.nListeners) {
                String interest = this.listenerInterests[i];
                if (interest == null || interest.equals(propertyName)) {
                    if (event == null) {
                        event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
                    }
                    this.listeners[i].propertyChange(event);
                }
                ++i;
            }
        }
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        XProperties xProperties = this;
        synchronized (xProperties) {
            if (this.listeners == null) {
                this.listeners = new PropertyChangeListener[16];
                this.listenerInterests = new String[this.listeners.length];
            }
            if (this.listeners.length == this.nListeners) {
                PropertyChangeListener[] oldListeners = this.listeners;
                this.listeners = new PropertyChangeListener[2 * this.nListeners];
                System.arraycopy(oldListeners, 0, this.listeners, 0, this.nListeners);
                String[] oldInterests = this.listenerInterests;
                this.listenerInterests = new String[2 * this.nListeners];
                System.arraycopy(oldInterests, 0, this.listenerInterests, 0, this.nListeners);
            }
            this.listeners[this.nListeners] = listener;
            this.listenerInterests[this.nListeners] = propertyName;
            ++this.nListeners;
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(null, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        XProperties xProperties = this;
        synchronized (xProperties) {
            int j = 0;
            int i = 0;
            while (i < this.nListeners) {
                if (this.listeners[i] != listener) {
                    this.listeners[j] = this.listeners[i];
                    this.listenerInterests[j] = this.listenerInterests[i];
                    ++j;
                }
                ++i;
            }
            int i2 = j;
            while (i2 < this.nListeners) {
                this.listeners[i2] = null;
                ++i2;
            }
            this.nListeners = j;
        }
    }

    public final void waitForPropertyChange() throws InterruptedException {
        this.waitForPropertyChange(null);
    }

    public final void waitForPropertyChange(final String propertyName) throws InterruptedException {
        final Object lock = new Object();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (propertyName == null || propertyName.equals(event.getPropertyName())) {
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
    }

    public final void set(Properties p) {
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = p.getProperty(name);
            this.setProperty(name, value);
        }
    }

    public final Object clone() {
        XProperties r = new XProperties(this.allowedPropertyNames, this.queue);
        r.set(this);
        return r;
    }
}

