/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.misc.Debug;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Properties;

public final class StringUtils {
    public static final char[] HEX_UPPER_CASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] HEX_LOWER_CASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final String PREFIX_SUBTREE = "{subtree}";
    static final String PREFIX_PACKAGE = "{package}";
    static final String PREFIX_CLASS = "{class}";
    static final String PREFIX_METHOD = "{method}";
    static final String PREFIX_FIELD = "{field}";

    private StringUtils() {
    }

    public static String[] split(String s, char separator) {
        int index1;
        int n = 1;
        int index = 0;
        while ((index = s.indexOf(separator, index)) != -1) {
            ++index;
            ++n;
        }
        String[] r = new String[n];
        index = 0;
        n = 0;
        while ((index1 = s.indexOf(separator, index)) != -1) {
            r[n] = s.substring(index, index1);
            index = index1 + 1;
            ++n;
        }
        r[n] = s.substring(index);
        return r;
    }

    public static String[] splitAndTrim(String s, char separator) {
        String[] a = StringUtils.split(s, separator);
        int n = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] != null && a[i].length() != 0) {
                a[n++] = a[i].trim();
            }
            ++i;
        }
        if (n != a.length) {
            String[] aOld = a;
            a = new String[n];
            System.arraycopy(aOld, 0, a, 0, n);
        }
        return a;
    }

    public static String concat(String[] a, char separator) {
        if (a == null || a.length == 0) {
            return "";
        }
        boolean isFirst = true;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < a.length) {
            if (a[i] != null) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(separator);
                }
                buffer.append(a[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean startsWith(String[] a, String[] b) {
        if (a.length < b.length) {
            return false;
        }
        int i = 0;
        while (i < b.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(String[] a, String[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] trimAll(String[] a) {
        int na = a.length;
        int i = 0;
        while (i < na) {
            a[i] = a[i].trim();
            ++i;
        }
        return a;
    }

    public static String fqNameToShortName(String fqName) {
        int index = fqName.lastIndexOf(46);
        return index == -1 ? fqName : fqName.substring(index + 1);
    }

    public static String fqNameToShortName(Class c) {
        return StringUtils.fqNameToShortName(c.getName());
    }

    public static String filePathToExtension(String filepath) {
        int lastIndexOfSlash = filepath.lastIndexOf(File.separatorChar);
        int lastIndexOfDot = filepath.lastIndexOf(46);
        return lastIndexOfDot > lastIndexOfSlash ? filepath.substring(lastIndexOfDot + 1) : "";
    }

    public static String escapeString(String s) {
        return StringUtils.escapeToJavaLiteral(s);
    }

    public static String escapeToHTML(String s) {
        StringBuffer buffer = new StringBuffer(s.length() * 2);
        char[] a = s.toCharArray();
        int na = a.length;
        int i = 0;
        while (i < na) {
            char ch = a[i];
            if (ch < ' ' || ch > '\u00ff') {
                buffer.append("&#").append((int)ch).append(';');
            } else {
                switch (ch) {
                    case ' ': {
                        buffer.append("&nbsp;");
                        break;
                    }
                    case '&': {
                        buffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        buffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        break;
                    }
                    case '\'': {
                        buffer.append("&apos;");
                        break;
                    }
                    case '\"': {
                        buffer.append("&quot;");
                        break;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String escapeToJavaLiteral(String s) {
        char[] a = s.toCharArray();
        StringBuffer b = new StringBuffer();
        int na = a.length;
        int i = 0;
        while (i < na) {
            char ch = a[i];
            if (ch < ' ' || ch > '\u00ff') {
                b.append("\\u");
                b.append(HEX_UPPER_CASE[ch >> 12 & 0xF]);
                b.append(HEX_UPPER_CASE[ch >> 8 & 0xF]);
                b.append(HEX_UPPER_CASE[ch >> 4 & 0xF]);
                b.append(HEX_UPPER_CASE[ch & 0xF]);
            } else {
                switch (a[i]) {
                    case '\b': {
                        b.append("\\b");
                        break;
                    }
                    case '\t': {
                        b.append("\\t");
                        break;
                    }
                    case '\n': {
                        b.append("\\n");
                        break;
                    }
                    case '\f': {
                        b.append("\\f");
                        break;
                    }
                    case '\r': {
                        b.append("\\r");
                        break;
                    }
                    case '\"': {
                        b.append("\\\"");
                        break;
                    }
                    case '\'': {
                        b.append("\\'");
                        break;
                    }
                    case '\\': {
                        b.append("\\\\");
                        break;
                    }
                    default: {
                        b.append(ch);
                    }
                }
            }
            ++i;
        }
        return b.toString();
    }

    public static String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(256);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static String toHexString(long number, int nDigits) {
        return StringUtils.toHexString(number, nDigits, true);
    }

    public static String toHexString(long number, int nDigits, boolean useUpperCase) {
        if ((Debug.DEBUG_CF || Debug.DEBUG_GUI || Debug.DEBUG_MODIFIER || Debug.DEBUG_TRACING) && (nDigits < 1 || nDigits > 16)) {
            throw new IllegalArgumentException();
        }
        char[] buffer = new char[nDigits];
        int iBuffer = 0;
        char[] HEX = useUpperCase ? HEX_UPPER_CASE : HEX_LOWER_CASE;
        int offset = (nDigits - 1) * 4;
        while (offset >= 0) {
            buffer[iBuffer++] = HEX[(int)(number >> offset & 0xFL)];
            offset -= 4;
        }
        return new String(buffer);
    }

    public static String toHexString(byte[] bytes, boolean useUpperCase) {
        return StringUtils.toHexString(bytes, 0, bytes.length, useUpperCase);
    }

    public static String toHexString(byte[] bytes, int start, int end, boolean useUpperCase) {
        if (bytes == null || start > end || start < 0 || end > bytes.length) {
            throw new IllegalArgumentException();
        }
        char[] buffer = new char[(end - start) * 2];
        int iBuffer = 0;
        char[] HEX = useUpperCase ? HEX_UPPER_CASE : HEX_LOWER_CASE;
        int i = start;
        while (i < end) {
            byte b = bytes[i];
            buffer[iBuffer++] = HEX[b >> 4 & 0xF];
            buffer[iBuffer++] = HEX[b & 0xF];
            ++i;
        }
        return new String(buffer);
    }

    public static String[] packageSystemIdentifierToPathOfLabels(String s) {
        String[] result;
        if (s == null) {
            throw new IllegalArgumentException(ResourceManager.get(167));
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException(ResourceManager.get(166));
        }
        if (s.indexOf(32) != -1) {
            throw new IllegalArgumentException(ResourceManager.get(165, s));
        }
        int indexOfDot = s.indexOf(46);
        if (indexOfDot == -1) {
            String[] a = StringUtils.split(s, '/');
            if (a[a.length - 1].equals("**")) {
                result = new String[a.length - 1];
                int i = 0;
                while (i < a.length - 1) {
                    result[i] = PREFIX_SUBTREE + a[i];
                    ++i;
                }
            } else if (a[a.length - 1].equals("*")) {
                result = new String[a.length];
                int i = 0;
                while (i < a.length - 1) {
                    result[i] = PREFIX_SUBTREE + a[i];
                    ++i;
                }
                result[a.length - 1] = PREFIX_PACKAGE;
            } else {
                result = new String[a.length + 1];
                int i = 0;
                while (i < a.length - 1) {
                    result[i] = PREFIX_SUBTREE + a[i];
                    ++i;
                }
                result[a.length - 1] = PREFIX_PACKAGE;
                result[a.length] = PREFIX_CLASS + a[a.length - 1];
            }
        } else {
            int indexOfOpeningBracket = s.indexOf(40);
            if (indexOfOpeningBracket == -1) {
                String[] a = StringUtils.packageSystemIdentifierToPathOfLabels(s.substring(0, indexOfDot));
                if (!a[a.length - 1].startsWith(PREFIX_CLASS)) {
                    throw new IllegalArgumentException(ResourceManager.get(164, s));
                }
                result = new String[a.length + 1];
                System.arraycopy(a, 0, result, 0, a.length);
                result[a.length] = PREFIX_FIELD + s.substring(indexOfDot + 1);
            } else {
                String[] a = StringUtils.packageSystemIdentifierToPathOfLabels(s.substring(0, indexOfDot));
                if (!a[a.length - 1].startsWith(PREFIX_CLASS)) {
                    throw new IllegalArgumentException(ResourceManager.get(164, s));
                }
                result = new String[a.length + 1];
                System.arraycopy(a, 0, result, 0, a.length);
                String methodDescriptor = s.substring(indexOfOpeningBracket);
                MethodInfo.checkMethodDescriptor(methodDescriptor);
                String methodNameAndDescriptor = s.substring(indexOfDot + 1);
                result[a.length] = PREFIX_METHOD + methodNameAndDescriptor;
            }
        }
        return result;
    }

    public static boolean isJLSIdentifier(String s) {
        if (s == null) {
            return false;
        }
        char[] ca = s.toCharArray();
        int nca = ca.length;
        if (nca == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(ca[0])) {
            return false;
        }
        int i = 1;
        while (i < nca) {
            if (!Character.isJavaIdentifierPart(ca[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJLSFullyQualifiedIdentifier(String s) {
        if (s == null) {
            return false;
        }
        String[] a = StringUtils.split(s, '.');
        int i = 0;
        while (i < a.length) {
            if (!StringUtils.isJLSIdentifier(a[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static File[] getAncestorsIncludingSelf(File file) {
        ArrayList<File> list = new ArrayList<File>();
        while (file != null) {
            list.add(file);
            file = file.getParentFile();
        }
        return list.toArray(new File[list.size()]);
    }

    public static Properties parseProperties(String s) {
        String[] pairs = StringUtils.splitAndTrim(s, ',');
        Properties r = new Properties();
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i] != null) {
                int indexOfEquals = pairs[i].indexOf(61);
                if (indexOfEquals == -1) {
                    r.setProperty(URLDecoder.decode(pairs[i]), "");
                } else {
                    r.setProperty(URLDecoder.decode(pairs[i].substring(0, indexOfEquals)), URLDecoder.decode(pairs[i].substring(indexOfEquals + 1)));
                }
            }
            ++i;
        }
        return r;
    }
}

