/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import com.sap.engine.library.bytecode.misc.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class PropertiesTree {
    private Map mapNameToPathsAndValues = new TreeMap();

    public void put(String[] path, String name, Object value) {
        ArrayList<Object[]> list = (ArrayList<Object[]>)this.mapNameToPathsAndValues.get(name);
        if (list == null) {
            list = new ArrayList<Object[]>();
            this.mapNameToPathsAndValues.put(name, list);
        }
        int nList = list.size();
        int i = 0;
        while (i < nList) {
            Object[] pathValuePair = (Object[])list.get(i);
            if (pathValuePair[0].equals(path)) {
                pathValuePair[1] = value;
                return;
            }
            ++i;
        }
        list.add(new Object[]{path, value});
    }

    public Object get(String[] path, String name) {
        ArrayList list = (ArrayList)this.mapNameToPathsAndValues.get(name);
        if (list == null) {
            return null;
        }
        int nList = list.size();
        int bestPathLength = -1;
        Object bestValue = null;
        int i = 0;
        while (i < nList) {
            Object[] pathValuePair = (Object[])list.get(i);
            String[] currentPath = (String[])pathValuePair[0];
            if (StringUtils.startsWith(path, currentPath) && currentPath.length > bestPathLength) {
                bestPathLength = currentPath.length;
                bestValue = pathValuePair[1];
            }
            ++i;
        }
        return bestValue;
    }

    public boolean hasDescendants(String[] path) {
        Iterator it = this.mapNameToPathsAndValues.values().iterator();
        while (it.hasNext()) {
            ArrayList list = (ArrayList)it.next();
            int nList = list.size();
            int i = 0;
            while (i < nList) {
                Object[] pathValuePair = (Object[])list.get(i);
                String[] currentPath = (String[])pathValuePair[0];
                if (StringUtils.startsWith(currentPath, path)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        PropertiesTree t = new PropertiesTree();
        t.put(StringUtils.split("a/b/c", '/'), "name", "value0");
        t.put(StringUtils.split("a/b/c/d", '/'), "name", "value1");
        System.out.println(t.get(StringUtils.split("a/b/c/d/.dssadf/asd.fasd/adfa/d", '/'), "name"));
    }
}

